/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.signers;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.DSA;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECAlgorithms;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECConstants;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ECDSASigner
implements DSA,
ECConstants {
    ECKeyParameters a;
    SecureRandom a;

    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.a = parametersWithRandom.getRandom();
                this.a = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.a = new SecureRandom();
                this.a = (ECPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.a = (ECPublicKeyParameters)cipherParameters;
        }
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        Object object;
        BigInteger[] bigIntegerArray;
        BigInteger bigInteger = this.a.getParameters().getN();
        BigInteger bigInteger2 = this.calculateE(bigInteger, byArray);
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        do {
            BigInteger bigInteger5;
            bigIntegerArray = null;
            int n2 = bigInteger.bitLength();
            while ((bigIntegerArray = new BigInteger(n2, this.a)).equals(ZERO) || bigIntegerArray.compareTo(bigInteger) >= 0 || (bigInteger3 = (bigInteger5 = ((ECPoint)(object = this.a.getParameters().getG().multiply((BigInteger)bigIntegerArray))).getX().toBigInteger()).mod(bigInteger)).equals(ZERO)) {
            }
            object = ((ECPrivateKeyParameters)this.a).getD();
        } while ((bigInteger4 = bigIntegerArray.modInverse(bigInteger).multiply(bigInteger2.add(((BigInteger)object).multiply(bigInteger3))).mod(bigInteger)).equals(ZERO));
        bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger4};
        return bigIntegerArray;
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint;
        BigInteger bigInteger3 = this.a.getParameters().getN();
        BigInteger bigInteger4 = this.calculateE(bigInteger3, byArray);
        if (bigInteger.compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger3) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(ONE) < 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger2.modInverse(bigInteger3);
        BigInteger bigInteger6 = bigInteger4.multiply(bigInteger5).mod(bigInteger3);
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger5).mod(bigInteger3);
        ECPoint eCPoint2 = this.a.getParameters().getG();
        ECPoint eCPoint3 = ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger6, eCPoint = ((ECPublicKeyParameters)this.a).getQ(), bigInteger7);
        if (eCPoint3.isInfinity()) {
            return false;
        }
        BigInteger bigInteger8 = eCPoint3.getX().toBigInteger().mod(bigInteger3);
        return bigInteger8.equals(bigInteger);
    }

    private BigInteger calculateE(BigInteger bigInteger, byte[] byArray) {
        int n2;
        int n3 = bigInteger.bitLength();
        if (n3 >= (n2 = byArray.length * 8)) {
            return new BigInteger(1, byArray);
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        bigInteger2 = bigInteger2.shiftRight(n2 - n3);
        return bigInteger2;
    }
}

