/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.signers;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.DSA;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.GOST3410KeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.GOST3410Parameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithRandom;
import java.math.BigInteger;
import java.security.SecureRandom;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GOST3410Signer
implements DSA {
    GOST3410KeyParameters a;
    SecureRandom a;

    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.a = parametersWithRandom.getRandom();
                this.a = (GOST3410PrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.a = new SecureRandom();
                this.a = (GOST3410PrivateKeyParameters)cipherParameters;
            }
        } else {
            this.a = (GOST3410PublicKeyParameters)cipherParameters;
        }
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        BigInteger bigInteger;
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            byArray2[i2] = byArray[byArray2.length - 1 - i2];
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        GOST3410Parameters gOST3410Parameters = this.a.getParameters();
        while ((bigInteger = new BigInteger(gOST3410Parameters.getQ().bitLength(), this.a)).compareTo(gOST3410Parameters.getQ()) >= 0) {
        }
        BigInteger bigInteger3 = gOST3410Parameters.getA().modPow(bigInteger, gOST3410Parameters.getP()).mod(gOST3410Parameters.getQ());
        BigInteger bigInteger4 = bigInteger.multiply(bigInteger2).add(((GOST3410PrivateKeyParameters)this.a).getX().multiply(bigInteger3)).mod(gOST3410Parameters.getQ());
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger4};
        return bigIntegerArray;
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            byArray2[i2] = byArray[byArray2.length - 1 - i2];
        }
        BigInteger bigInteger3 = new BigInteger(1, byArray2);
        GOST3410Parameters gOST3410Parameters = this.a.getParameters();
        BigInteger bigInteger4 = BigInteger.valueOf(0L);
        if (bigInteger4.compareTo(bigInteger) >= 0 || gOST3410Parameters.getQ().compareTo(bigInteger) <= 0) {
            return false;
        }
        if (bigInteger4.compareTo(bigInteger2) >= 0 || gOST3410Parameters.getQ().compareTo(bigInteger2) <= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger3.modPow(gOST3410Parameters.getQ().subtract(new BigInteger("2")), gOST3410Parameters.getQ());
        BigInteger bigInteger6 = bigInteger2.multiply(bigInteger5).mod(gOST3410Parameters.getQ());
        BigInteger bigInteger7 = gOST3410Parameters.getQ().subtract(bigInteger).multiply(bigInteger5).mod(gOST3410Parameters.getQ());
        bigInteger6 = gOST3410Parameters.getA().modPow(bigInteger6, gOST3410Parameters.getP());
        bigInteger7 = ((GOST3410PublicKeyParameters)this.a).getY().modPow(bigInteger7, gOST3410Parameters.getP());
        BigInteger bigInteger8 = bigInteger6.multiply(bigInteger7).mod(gOST3410Parameters.getP()).mod(gOST3410Parameters.getQ());
        return bigInteger8.equals(bigInteger);
    }
}

