/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.Certificate;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.ProtocolVersion;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsContext;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsCredentials;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsKeyExchange;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public abstract class AbstractTlsKeyExchange
implements TlsKeyExchange {
    protected int keyExchange;
    protected Vector supportedSignatureAlgorithms;
    protected TlsContext context;

    protected AbstractTlsKeyExchange(int n2, Vector vector) {
        this.keyExchange = n2;
        this.supportedSignatureAlgorithms = vector;
    }

    public void init(TlsContext tlsContext) {
        block7: {
            ProtocolVersion protocolVersion;
            block6: {
                this.context = tlsContext;
                protocolVersion = tlsContext.getClientVersion();
                if (!TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) break block6;
                if (this.supportedSignatureAlgorithms != null) break block7;
                switch (this.keyExchange) {
                    case 3: 
                    case 7: 
                    case 22: {
                        this.supportedSignatureAlgorithms = TlsUtils.getDefaultDSSSignatureAlgorithms();
                        break block7;
                    }
                    case 16: 
                    case 17: {
                        this.supportedSignatureAlgorithms = TlsUtils.getDefaultECDSASignatureAlgorithms();
                        break block7;
                    }
                    case 1: 
                    case 5: 
                    case 9: 
                    case 15: 
                    case 18: 
                    case 19: 
                    case 23: {
                        this.supportedSignatureAlgorithms = TlsUtils.getDefaultRSASignatureAlgorithms();
                        break block7;
                    }
                    default: {
                        throw new IllegalStateException("unsupported key exchange algorithm");
                    }
                }
            }
            if (this.supportedSignatureAlgorithms != null) {
                throw new IllegalStateException("supported_signature_algorithms not allowed for " + protocolVersion);
            }
        }
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        if (this.supportedSignatureAlgorithms == null) {
            // empty if block
        }
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        this.processServerCertificate(tlsCredentials.getCertificate());
    }

    public boolean requiresServerKeyExchange() {
        return false;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(80);
        }
        return null;
    }

    public void skipServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    public void skipClientCredentials() throws IOException {
    }

    public void processClientCertificate(Certificate certificate) throws IOException {
    }

    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        throw new TlsFatalAlert(80);
    }
}

