/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsRuntimeException;

public class ByteQueue {
    private static final int INITBUFSIZE = 1024;
    private byte[] databuf = new byte[1024];
    private int skipped = 0;
    private int available = 0;

    public static final int nextTwoPow(int n2) {
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        return n2 + 1;
    }

    public void read(byte[] byArray, int n2, int n3, int n4) {
        if (this.available - n4 < n3) {
            throw new TlsRuntimeException("Not enough data to read");
        }
        if (byArray.length - n2 < n3) {
            throw new TlsRuntimeException("Buffer size of " + byArray.length + " is too small for a read of " + n3 + " bytes");
        }
        System.arraycopy(this.databuf, this.skipped + n4, byArray, n2, n3);
    }

    public void addData(byte[] byArray, int n2, int n3) {
        if (this.skipped + this.available + n3 > this.databuf.length) {
            byte[] byArray2 = new byte[ByteQueue.nextTwoPow(byArray.length)];
            System.arraycopy(this.databuf, this.skipped, byArray2, 0, this.available);
            this.skipped = 0;
            this.databuf = byArray2;
        }
        System.arraycopy(byArray, n2, this.databuf, this.skipped + this.available, n3);
        this.available += n3;
    }

    public void removeData(int n2) {
        if (n2 > this.available) {
            throw new TlsRuntimeException("Cannot remove " + n2 + " bytes, only got " + this.available);
        }
        this.available -= n2;
        this.skipped += n2;
        if (this.skipped > this.databuf.length / 2) {
            System.arraycopy(this.databuf, this.skipped, this.databuf, 0, this.available);
            this.skipped = 0;
        }
    }

    public int size() {
        return this.available;
    }
}

