/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x500.X500Name;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class CertificateRequest {
    private short[] certificateTypes;
    private Vector certificateAuthorities;

    public CertificateRequest(short[] sArray, Vector vector) {
        this.certificateTypes = sArray;
        this.certificateAuthorities = vector;
    }

    public short[] getCertificateTypes() {
        return this.certificateTypes;
    }

    public Vector getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.certificateTypes == null || this.certificateTypes.length == 0) {
            TlsUtils.writeUint8((short)0, outputStream);
        } else {
            TlsUtils.writeUint8((short)this.certificateTypes.length, outputStream);
            TlsUtils.writeUint8Array(this.certificateTypes, outputStream);
        }
        if (this.certificateAuthorities == null || this.certificateAuthorities.isEmpty()) {
            TlsUtils.writeUint16(0, outputStream);
        } else {
            Object object;
            int n2;
            Vector<byte[]> vector = new Vector<byte[]>(this.certificateAuthorities.size());
            int n3 = 0;
            for (n2 = 0; n2 < this.certificateAuthorities.size(); ++n2) {
                object = (X500Name)this.certificateAuthorities.elementAt(n2);
                byte[] byArray = ((ASN1Object)object).getEncoded("DER");
                vector.addElement(byArray);
                n3 += byArray.length;
            }
            TlsUtils.writeUint16(n3, outputStream);
            for (n2 = 0; n2 < vector.size(); ++n2) {
                object = (byte[])vector.elementAt(n2);
                outputStream.write((byte[])object);
            }
        }
    }

    public static CertificateRequest parse(InputStream inputStream) throws IOException {
        int n2 = TlsUtils.readUint8(inputStream);
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = TlsUtils.readUint8(inputStream);
        }
        byte[] byArray = TlsUtils.readOpaque16(inputStream);
        Vector<X500Name> vector = new Vector<X500Name>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        while (byteArrayInputStream.available() > 0) {
            byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream);
            vector.addElement(X500Name.getInstance(ASN1Primitive.fromByteArray(byArray2)));
        }
        return new CertificateRequest(sArray, vector);
    }
}

