/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.SSL3Mac;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsContext;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsHandshakeHash;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;

class CombinedHash
implements TlsHandshakeHash {
    protected TlsContext context;
    protected Digest md5;
    protected Digest sha1;

    CombinedHash() {
        this.md5 = TlsUtils.createHash(1);
        this.sha1 = TlsUtils.createHash(2);
    }

    CombinedHash(CombinedHash combinedHash) {
        this.context = combinedHash.context;
        this.md5 = TlsUtils.cloneHash(1, combinedHash.md5);
        this.sha1 = TlsUtils.cloneHash(2, combinedHash.sha1);
    }

    public void init(TlsContext tlsContext) {
        this.context = tlsContext;
    }

    public TlsHandshakeHash commit() {
        return this;
    }

    public TlsHandshakeHash fork() {
        return new CombinedHash(this);
    }

    public String getAlgorithmName() {
        return this.md5.getAlgorithmName() + " and " + this.sha1.getAlgorithmName();
    }

    public int getDigestSize() {
        return this.md5.getDigestSize() + this.sha1.getDigestSize();
    }

    public void update(byte by2) {
        this.md5.update(by2);
        this.sha1.update(by2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.md5.update(byArray, n2, n3);
        this.sha1.update(byArray, n2, n3);
    }

    public int doFinal(byte[] byArray, int n2) {
        if (this.context != null && this.context.getServerVersion().isSSL()) {
            this.ssl3Complete(this.md5, SSL3Mac.a, SSL3Mac.b, 48);
            this.ssl3Complete(this.sha1, SSL3Mac.a, SSL3Mac.b, 40);
        }
        int n3 = this.md5.doFinal(byArray, n2);
        int n4 = this.sha1.doFinal(byArray, n2 + n3);
        return n3 + n4;
    }

    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }

    protected void ssl3Complete(Digest digest, byte[] byArray, byte[] byArray2, int n2) {
        byte[] byArray3 = this.context.getSecurityParameters().a;
        digest.update(byArray3, 0, byArray3.length);
        digest.update(byArray, 0, n2);
        byte[] byArray4 = new byte[digest.getDigestSize()];
        digest.doFinal(byArray4, 0);
        digest.update(byArray3, 0, byArray3.length);
        digest.update(byArray2, 0, n2);
        digest.update(byArray4, 0, byArray4.length);
    }
}

