/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSReassembler;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSRecordLayer;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSReliableHandshake$1;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSReliableHandshake$Message;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DeferredHash;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsContext;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsHandshakeHash;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import com.zeroturnaround.bundled.org.bouncycastle.util.Integers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
class DTLSReliableHandshake {
    private static final int MAX_RECEIVE_AHEAD = 10;
    private final DTLSRecordLayer recordLayer;
    private TlsHandshakeHash hash = new DeferredHash();
    private Hashtable currentInboundFlight = new Hashtable();
    private Hashtable previousInboundFlight = null;
    private Vector outboundFlight = new Vector();
    private boolean sending = true;
    private int message_seq = 0;
    private int next_receive_seq = 0;

    DTLSReliableHandshake(TlsContext tlsContext, DTLSRecordLayer dTLSRecordLayer) {
        this.recordLayer = dTLSRecordLayer;
        this.hash.init(tlsContext);
    }

    void a() {
        this.hash = this.hash.commit();
    }

    byte[] a() {
        TlsHandshakeHash tlsHandshakeHash = this.hash.fork();
        byte[] byArray = new byte[tlsHandshakeHash.getDigestSize()];
        tlsHandshakeHash.doFinal(byArray, 0);
        return byArray;
    }

    void a(short s2, byte[] byArray) throws IOException {
        if (!this.sending) {
            this.checkInboundFlight();
            this.sending = true;
            this.outboundFlight.removeAllElements();
        }
        DTLSReliableHandshake$Message dTLSReliableHandshake$Message = new DTLSReliableHandshake$Message(this.message_seq++, s2, byArray, null);
        this.outboundFlight.addElement(dTLSReliableHandshake$Message);
        this.writeMessage(dTLSReliableHandshake$Message);
        this.updateHandshakeMessagesDigest(dTLSReliableHandshake$Message);
    }

    DTLSReliableHandshake$Message a() throws IOException {
        byte[] byArray;
        Object object;
        if (this.sending) {
            this.sending = false;
            this.prepareInboundFlight();
        }
        if ((object = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf(this.next_receive_seq))) != null && (byArray = ((DTLSReassembler)object).a()) != null) {
            this.previousInboundFlight = null;
            return this.updateHandshakeMessagesDigest(new DTLSReliableHandshake$Message(this.next_receive_seq++, ((DTLSReassembler)object).a(), byArray, null));
        }
        object = null;
        int n2 = 1000;
        while (true) {
            int n3 = this.recordLayer.getReceiveLimit();
            if (object == null || ((DTLSReassembler)object).length < n3) {
                object = new byte[n3];
            }
            try {
                int n4;
                while ((n4 = this.recordLayer.receive((byte[])object, 0, n3, n2)) >= 0) {
                    byte[] byArray2;
                    DTLSReassembler dTLSReassembler;
                    int n5;
                    int n6;
                    if (n4 < 12 || n4 != (n6 = TlsUtils.readUint24((byte[])object, 9)) + 12 || (n5 = TlsUtils.readUint16((byte[])object, 4)) > this.next_receive_seq + 10) continue;
                    short s2 = TlsUtils.readUint8((byte[])object, 0);
                    int n7 = TlsUtils.readUint24((byte[])object, 1);
                    int n8 = TlsUtils.readUint24((byte[])object, 6);
                    if (n8 + n6 > n7) continue;
                    if (n5 < this.next_receive_seq) {
                        if (this.previousInboundFlight == null || (dTLSReassembler = (DTLSReassembler)this.previousInboundFlight.get(Integers.valueOf(n5))) == null) continue;
                        dTLSReassembler.a(s2, n7, (byte[])object, 12, n8, n6);
                        if (!DTLSReliableHandshake.checkAll(this.previousInboundFlight)) continue;
                        this.resendOutboundFlight();
                        n2 = Math.min(n2 * 2, 60000);
                        DTLSReliableHandshake.resetAll(this.previousInboundFlight);
                        continue;
                    }
                    dTLSReassembler = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf(n5));
                    if (dTLSReassembler == null) {
                        dTLSReassembler = new DTLSReassembler(s2, n7);
                        this.currentInboundFlight.put(Integers.valueOf(n5), dTLSReassembler);
                    }
                    dTLSReassembler.a(s2, n7, (byte[])object, 12, n8, n6);
                    if (n5 != this.next_receive_seq || (byArray2 = dTLSReassembler.a()) == null) continue;
                    this.previousInboundFlight = null;
                    return this.updateHandshakeMessagesDigest(new DTLSReliableHandshake$Message(this.next_receive_seq++, dTLSReassembler.a(), byArray2, null));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.resendOutboundFlight();
            n2 = Math.min(n2 * 2, 60000);
        }
    }

    void b() {
        DTLSReliableHandshake$1 dTLSReliableHandshake$1 = null;
        if (!this.sending) {
            this.checkInboundFlight();
        } else if (this.currentInboundFlight != null) {
            dTLSReliableHandshake$1 = new DTLSReliableHandshake$1(this);
        }
        this.recordLayer.a(dTLSReliableHandshake$1);
    }

    void c() {
        this.hash.reset();
    }

    private void checkInboundFlight() {
        Enumeration enumeration = this.currentInboundFlight.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            if (n2 < this.next_receive_seq) continue;
        }
    }

    private void prepareInboundFlight() {
        DTLSReliableHandshake.resetAll(this.currentInboundFlight);
        this.previousInboundFlight = this.currentInboundFlight;
        this.currentInboundFlight = new Hashtable();
    }

    private void resendOutboundFlight() throws IOException {
        this.recordLayer.a();
        for (int i2 = 0; i2 < this.outboundFlight.size(); ++i2) {
            this.writeMessage((DTLSReliableHandshake$Message)this.outboundFlight.elementAt(i2));
        }
    }

    private DTLSReliableHandshake$Message updateHandshakeMessagesDigest(DTLSReliableHandshake$Message dTLSReliableHandshake$Message) throws IOException {
        if (dTLSReliableHandshake$Message.getType() != 0) {
            byte[] byArray = dTLSReliableHandshake$Message.getBody();
            byte[] byArray2 = new byte[12];
            TlsUtils.writeUint8(dTLSReliableHandshake$Message.getType(), byArray2, 0);
            TlsUtils.writeUint24(byArray.length, byArray2, 1);
            TlsUtils.writeUint16(dTLSReliableHandshake$Message.getSeq(), byArray2, 4);
            TlsUtils.writeUint24(0, byArray2, 6);
            TlsUtils.writeUint24(byArray.length, byArray2, 9);
            this.hash.update(byArray2, 0, byArray2.length);
            this.hash.update(byArray, 0, byArray.length);
        }
        return dTLSReliableHandshake$Message;
    }

    private void writeMessage(DTLSReliableHandshake$Message dTLSReliableHandshake$Message) throws IOException {
        int n2;
        int n3 = this.recordLayer.getSendLimit();
        int n4 = n3 - 12;
        if (n4 < 1) {
            throw new TlsFatalAlert(80);
        }
        int n5 = dTLSReliableHandshake$Message.getBody().length;
        int n6 = 0;
        do {
            n2 = Math.min(n5 - n6, n4);
            this.writeHandshakeFragment(dTLSReliableHandshake$Message, n6, n2);
        } while ((n6 += n2) < n5);
    }

    private void writeHandshakeFragment(DTLSReliableHandshake$Message dTLSReliableHandshake$Message, int n2, int n3) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8(dTLSReliableHandshake$Message.getType(), byteArrayOutputStream);
        TlsUtils.writeUint24(dTLSReliableHandshake$Message.getBody().length, byteArrayOutputStream);
        TlsUtils.writeUint16(dTLSReliableHandshake$Message.getSeq(), byteArrayOutputStream);
        TlsUtils.writeUint24(n2, byteArrayOutputStream);
        TlsUtils.writeUint24(n3, byteArrayOutputStream);
        byteArrayOutputStream.write(dTLSReliableHandshake$Message.getBody(), n2, n3);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.recordLayer.send(byArray, 0, byArray.length);
    }

    private static boolean checkAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (((DTLSReassembler)enumeration.nextElement()).a() != null) continue;
            return false;
        }
        return true;
    }

    private static void resetAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ((DTLSReassembler)enumeration.nextElement()).a();
        }
    }

    static int a(DTLSReliableHandshake dTLSReliableHandshake) {
        return dTLSReliableHandshake.next_receive_seq;
    }

    static Hashtable a(DTLSReliableHandshake dTLSReliableHandshake) {
        return dTLSReliableHandshake.currentInboundFlight;
    }

    static boolean a(Hashtable hashtable) {
        return DTLSReliableHandshake.checkAll(hashtable);
    }

    static void a(DTLSReliableHandshake dTLSReliableHandshake) throws IOException {
        dTLSReliableHandshake.resendOutboundFlight();
    }

    static void a(Hashtable hashtable) {
        DTLSReliableHandshake.resetAll(hashtable);
    }
}

