/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.Certificate;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.CertificateRequest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSProtocol;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSRecordLayer;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSReliableHandshake;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSReliableHandshake$Message;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSServerProtocol$ServerHandshakeState;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSTransport;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DatagramTransport;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.NewSessionTicket;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.ProtocolVersion;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.SecurityParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsProtocol;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsServer;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsServerContextImpl;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.util.PublicKeyFactory;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;

public class DTLSServerProtocol
extends DTLSProtocol {
    protected boolean verifyRequests = true;

    public DTLSServerProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public boolean getVerifyRequests() {
        return this.verifyRequests;
    }

    public void setVerifyRequests(boolean bl2) {
        this.verifyRequests = bl2;
    }

    public DTLSTransport accept(TlsServer tlsServer, DatagramTransport datagramTransport) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'server' cannot be null");
        }
        if (datagramTransport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.a = 0;
        securityParameters.c = TlsProtocol.createRandomBlock(this.secureRandom);
        DTLSServerProtocol$ServerHandshakeState dTLSServerProtocol$ServerHandshakeState = new DTLSServerProtocol$ServerHandshakeState();
        dTLSServerProtocol$ServerHandshakeState.a = tlsServer;
        dTLSServerProtocol$ServerHandshakeState.a = new TlsServerContextImpl(this.secureRandom, securityParameters);
        tlsServer.init(dTLSServerProtocol$ServerHandshakeState.a);
        DTLSRecordLayer dTLSRecordLayer = new DTLSRecordLayer(datagramTransport, dTLSServerProtocol$ServerHandshakeState.a, tlsServer, 22);
        try {
            return this.serverHandshake(dTLSServerProtocol$ServerHandshakeState, dTLSRecordLayer);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            dTLSRecordLayer.a(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            dTLSRecordLayer.a((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            dTLSRecordLayer.a((short)80);
            throw new TlsFatalAlert(80);
        }
    }

    public DTLSTransport serverHandshake(DTLSServerProtocol$ServerHandshakeState dTLSServerProtocol$ServerHandshakeState, DTLSRecordLayer dTLSRecordLayer) throws IOException {
        Object object;
        byte[] byArray;
        SecurityParameters securityParameters = dTLSServerProtocol$ServerHandshakeState.a.getSecurityParameters();
        DTLSReliableHandshake dTLSReliableHandshake = new DTLSReliableHandshake(dTLSServerProtocol$ServerHandshakeState.a, dTLSRecordLayer);
        DTLSReliableHandshake$Message dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        Object object2 = dTLSRecordLayer.a();
        dTLSServerProtocol$ServerHandshakeState.a.setClientVersion((ProtocolVersion)object2);
        if (dTLSReliableHandshake$Message.getType() != 1) {
            throw new TlsFatalAlert(10);
        }
        this.processClientHello(dTLSServerProtocol$ServerHandshakeState, dTLSReliableHandshake$Message.getBody());
        object2 = this.generateServerHello(dTLSServerProtocol$ServerHandshakeState);
        dTLSReliableHandshake.a((short)2, (byte[])object2);
        securityParameters.b = TlsProtocol.getPRFAlgorithm(dTLSServerProtocol$ServerHandshakeState.a);
        securityParameters.a = dTLSServerProtocol$ServerHandshakeState.a;
        securityParameters.c = 12;
        dTLSReliableHandshake.a();
        Vector vector = dTLSServerProtocol$ServerHandshakeState.a.getServerSupplementalData();
        if (vector != null) {
            byArray = DTLSServerProtocol.generateSupplementalData(vector);
            dTLSReliableHandshake.a((short)23, byArray);
        }
        dTLSServerProtocol$ServerHandshakeState.a = dTLSServerProtocol$ServerHandshakeState.a.getKeyExchange();
        dTLSServerProtocol$ServerHandshakeState.a.init(dTLSServerProtocol$ServerHandshakeState.a);
        dTLSServerProtocol$ServerHandshakeState.a = dTLSServerProtocol$ServerHandshakeState.a.getCredentials();
        if (dTLSServerProtocol$ServerHandshakeState.a == null) {
            dTLSServerProtocol$ServerHandshakeState.a.skipServerCredentials();
        } else {
            dTLSServerProtocol$ServerHandshakeState.a.processServerCredentials(dTLSServerProtocol$ServerHandshakeState.a);
            byArray = DTLSServerProtocol.generateCertificate(dTLSServerProtocol$ServerHandshakeState.a.getCertificate());
            dTLSReliableHandshake.a((short)11, byArray);
        }
        byArray = dTLSServerProtocol$ServerHandshakeState.a.generateServerKeyExchange();
        if (byArray != null) {
            dTLSReliableHandshake.a((short)12, byArray);
        }
        if (dTLSServerProtocol$ServerHandshakeState.a != null) {
            dTLSServerProtocol$ServerHandshakeState.a = dTLSServerProtocol$ServerHandshakeState.a.getCertificateRequest();
            if (dTLSServerProtocol$ServerHandshakeState.a != null) {
                dTLSServerProtocol$ServerHandshakeState.a.validateCertificateRequest(dTLSServerProtocol$ServerHandshakeState.a);
                object = this.generateCertificateRequest(dTLSServerProtocol$ServerHandshakeState, dTLSServerProtocol$ServerHandshakeState.a);
                dTLSReliableHandshake.a((short)13, (byte[])object);
            }
        }
        dTLSReliableHandshake.a((short)14, TlsUtils.EMPTY_BYTES);
        dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        if (dTLSReliableHandshake$Message.getType() == 23) {
            this.processClientSupplementalData(dTLSServerProtocol$ServerHandshakeState, dTLSReliableHandshake$Message.getBody());
            dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        } else {
            dTLSServerProtocol$ServerHandshakeState.a.processClientSupplementalData(null);
        }
        if (dTLSServerProtocol$ServerHandshakeState.a == null) {
            dTLSServerProtocol$ServerHandshakeState.a.skipClientCredentials();
        } else if (dTLSReliableHandshake$Message.getType() == 11) {
            this.processClientCertificate(dTLSServerProtocol$ServerHandshakeState, dTLSReliableHandshake$Message.getBody());
            dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        } else {
            object = dTLSServerProtocol$ServerHandshakeState.a.getServerVersion().getEquivalentTLSVersion();
            if (ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf((ProtocolVersion)object)) {
                throw new TlsFatalAlert(10);
            }
            this.notifyClientCertificate(dTLSServerProtocol$ServerHandshakeState, Certificate.EMPTY_CHAIN);
        }
        if (dTLSReliableHandshake$Message.getType() != 16) {
            throw new TlsFatalAlert(10);
        }
        this.processClientKeyExchange(dTLSServerProtocol$ServerHandshakeState, dTLSReliableHandshake$Message.getBody());
        dTLSRecordLayer.a(dTLSServerProtocol$ServerHandshakeState.a.getCipher());
        if (this.expectCertificateVerifyMessage(dTLSServerProtocol$ServerHandshakeState)) {
            object = dTLSReliableHandshake.a();
            dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
            if (dTLSReliableHandshake$Message.getType() == 15) {
                this.processCertificateVerify(dTLSServerProtocol$ServerHandshakeState, dTLSReliableHandshake$Message.getBody(), (byte[])object);
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        object = dTLSReliableHandshake.a();
        dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        if (dTLSReliableHandshake$Message.getType() != 20) {
            throw new TlsFatalAlert(10);
        }
        Object object3 = TlsUtils.a(dTLSServerProtocol$ServerHandshakeState.a, "client finished", object);
        this.processFinished(dTLSReliableHandshake$Message.getBody(), (byte[])object3);
        if (dTLSServerProtocol$ServerHandshakeState.b) {
            object3 = dTLSServerProtocol$ServerHandshakeState.a.getNewSessionTicket();
            byte[] byArray2 = this.generateNewSessionTicket(dTLSServerProtocol$ServerHandshakeState, (NewSessionTicket)object3);
            dTLSReliableHandshake.a((short)4, byArray2);
        }
        object3 = TlsUtils.a(dTLSServerProtocol$ServerHandshakeState.a, "server finished", dTLSReliableHandshake.a());
        dTLSReliableHandshake.a((short)20, (byte[])object3);
        dTLSReliableHandshake.b();
        dTLSServerProtocol$ServerHandshakeState.a.notifyHandshakeComplete();
        return new DTLSTransport(dTLSRecordLayer);
    }

    protected byte[] generateCertificateRequest(DTLSServerProtocol$ServerHandshakeState dTLSServerProtocol$ServerHandshakeState, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateNewSessionTicket(DTLSServerProtocol$ServerHandshakeState dTLSServerProtocol$ServerHandshakeState, NewSessionTicket newSessionTicket) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        newSessionTicket.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateServerHello(DTLSServerProtocol$ServerHandshakeState dTLSServerProtocol$ServerHandshakeState) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProtocolVersion protocolVersion = dTLSServerProtocol$ServerHandshakeState.a.getServerVersion();
        if (!protocolVersion.isEqualOrEarlierVersionOf(dTLSServerProtocol$ServerHandshakeState.a.getClientVersion())) {
            throw new TlsFatalAlert(80);
        }
        dTLSServerProtocol$ServerHandshakeState.a.setServerVersion(protocolVersion);
        TlsUtils.writeVersion(dTLSServerProtocol$ServerHandshakeState.a.getServerVersion(), byteArrayOutputStream);
        byteArrayOutputStream.write(dTLSServerProtocol$ServerHandshakeState.a.getSecurityParameters().c);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        dTLSServerProtocol$ServerHandshakeState.a = dTLSServerProtocol$ServerHandshakeState.a.getSelectedCipherSuite();
        if (!TlsProtocol.arrayContains(dTLSServerProtocol$ServerHandshakeState.a, dTLSServerProtocol$ServerHandshakeState.a) || dTLSServerProtocol$ServerHandshakeState.a == 0 || dTLSServerProtocol$ServerHandshakeState.a == 255) {
            throw new TlsFatalAlert(80);
        }
        DTLSServerProtocol.validateSelectedCipherSuite(dTLSServerProtocol$ServerHandshakeState.a, (short)80);
        dTLSServerProtocol$ServerHandshakeState.a = dTLSServerProtocol$ServerHandshakeState.a.getSelectedCompressionMethod();
        if (!TlsProtocol.arrayContains(dTLSServerProtocol$ServerHandshakeState.a, dTLSServerProtocol$ServerHandshakeState.a)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint16(dTLSServerProtocol$ServerHandshakeState.a, byteArrayOutputStream);
        TlsUtils.writeUint8(dTLSServerProtocol$ServerHandshakeState.a, byteArrayOutputStream);
        dTLSServerProtocol$ServerHandshakeState.b = dTLSServerProtocol$ServerHandshakeState.a.getServerExtensions();
        if (dTLSServerProtocol$ServerHandshakeState.a) {
            boolean bl2;
            boolean bl3 = bl2 = dTLSServerProtocol$ServerHandshakeState.b == null || !dTLSServerProtocol$ServerHandshakeState.b.containsKey(TlsProtocol.EXT_RenegotiationInfo);
            if (bl2) {
                if (dTLSServerProtocol$ServerHandshakeState.b == null) {
                    dTLSServerProtocol$ServerHandshakeState.b = new Hashtable();
                }
                dTLSServerProtocol$ServerHandshakeState.b.put(TlsProtocol.EXT_RenegotiationInfo, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (dTLSServerProtocol$ServerHandshakeState.b != null) {
            dTLSServerProtocol$ServerHandshakeState.b = dTLSServerProtocol$ServerHandshakeState.b.containsKey(TlsProtocol.EXT_SessionTicket);
            TlsProtocol.writeExtensions(byteArrayOutputStream, dTLSServerProtocol$ServerHandshakeState.b);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected void notifyClientCertificate(DTLSServerProtocol$ServerHandshakeState dTLSServerProtocol$ServerHandshakeState, Certificate certificate) throws IOException {
        if (dTLSServerProtocol$ServerHandshakeState.a == null) {
            throw new IllegalStateException();
        }
        if (dTLSServerProtocol$ServerHandshakeState.a != null) {
            throw new TlsFatalAlert(10);
        }
        dTLSServerProtocol$ServerHandshakeState.a = certificate;
        if (certificate.isEmpty()) {
            dTLSServerProtocol$ServerHandshakeState.a.skipClientCredentials();
        } else {
            dTLSServerProtocol$ServerHandshakeState.b = TlsUtils.a(certificate, dTLSServerProtocol$ServerHandshakeState.a.getCertificate());
            dTLSServerProtocol$ServerHandshakeState.a.processClientCertificate(certificate);
        }
        dTLSServerProtocol$ServerHandshakeState.a.notifyClientCertificate(certificate);
    }

    protected void processClientCertificate(DTLSServerProtocol$ServerHandshakeState dTLSServerProtocol$ServerHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate certificate = Certificate.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(dTLSServerProtocol$ServerHandshakeState, certificate);
    }

    protected void processCertificateVerify(DTLSServerProtocol$ServerHandshakeState dTLSServerProtocol$ServerHandshakeState, byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray3 = TlsUtils.readOpaque16(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        try {
            TlsSigner tlsSigner = TlsUtils.createTlsSigner(dTLSServerProtocol$ServerHandshakeState.b);
            tlsSigner.init(dTLSServerProtocol$ServerHandshakeState.a);
            com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate certificate = dTLSServerProtocol$ServerHandshakeState.a.getCertificateAt(0);
            SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getSubjectPublicKeyInfo();
            AsymmetricKeyParameter asymmetricKeyParameter = PublicKeyFactory.createKey(subjectPublicKeyInfo);
            tlsSigner.verifyRawSignature(byArray3, asymmetricKeyParameter, byArray2);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(51);
        }
    }

    protected void processClientHello(DTLSServerProtocol$ServerHandshakeState dTLSServerProtocol$ServerHandshakeState, byte[] byArray) throws IOException {
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray3 = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray4 = TlsUtils.readOpaque8(byteArrayInputStream);
        if (byArray4.length > 32) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray5 = TlsUtils.readOpaque8(byteArrayInputStream);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        dTLSServerProtocol$ServerHandshakeState.a = TlsUtils.readUint16Array(n2 / 2, byteArrayInputStream);
        short s2 = TlsUtils.readUint8(byteArrayInputStream);
        if (s2 < 1) {
            throw new TlsFatalAlert(47);
        }
        dTLSServerProtocol$ServerHandshakeState.a = TlsUtils.readUint8Array(s2, byteArrayInputStream);
        dTLSServerProtocol$ServerHandshakeState.a = TlsProtocol.readExtensions(byteArrayInputStream);
        dTLSServerProtocol$ServerHandshakeState.a.setClientVersion(protocolVersion);
        dTLSServerProtocol$ServerHandshakeState.a.notifyClientVersion(protocolVersion);
        dTLSServerProtocol$ServerHandshakeState.a.getSecurityParameters().b = byArray3;
        dTLSServerProtocol$ServerHandshakeState.a.notifyOfferedCipherSuites(dTLSServerProtocol$ServerHandshakeState.a);
        dTLSServerProtocol$ServerHandshakeState.a.notifyOfferedCompressionMethods(dTLSServerProtocol$ServerHandshakeState.a);
        if (TlsProtocol.arrayContains(dTLSServerProtocol$ServerHandshakeState.a, 255)) {
            dTLSServerProtocol$ServerHandshakeState.a = true;
        }
        if (dTLSServerProtocol$ServerHandshakeState.a != null && (byArray2 = (byte[])dTLSServerProtocol$ServerHandshakeState.a.get(TlsProtocol.EXT_RenegotiationInfo)) != null) {
            dTLSServerProtocol$ServerHandshakeState.a = true;
            if (!Arrays.constantTimeAreEqual(byArray2, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        dTLSServerProtocol$ServerHandshakeState.a.notifySecureRenegotiation(dTLSServerProtocol$ServerHandshakeState.a);
        if (dTLSServerProtocol$ServerHandshakeState.a != null) {
            dTLSServerProtocol$ServerHandshakeState.a.processClientExtensions(dTLSServerProtocol$ServerHandshakeState.a);
        }
    }

    protected void processClientKeyExchange(DTLSServerProtocol$ServerHandshakeState dTLSServerProtocol$ServerHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        dTLSServerProtocol$ServerHandshakeState.a.processClientKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        TlsProtocol.establishMasterSecret(dTLSServerProtocol$ServerHandshakeState.a, dTLSServerProtocol$ServerHandshakeState.a);
    }

    protected void processClientSupplementalData(DTLSServerProtocol$ServerHandshakeState dTLSServerProtocol$ServerHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        dTLSServerProtocol$ServerHandshakeState.a.processClientSupplementalData(vector);
    }

    protected boolean expectCertificateVerifyMessage(DTLSServerProtocol$ServerHandshakeState dTLSServerProtocol$ServerHandshakeState) {
        return dTLSServerProtocol$ServerHandshakeState.b >= 0 && TlsUtils.hasSigningCapability(dTLSServerProtocol$ServerHandshakeState.b);
    }
}

