/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.AbstractTlsClient;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsCipherFactory;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsKeyExchange;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsSRPKeyExchange;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import com.zeroturnaround.bundled.org.bouncycastle.util.Integers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public abstract class SRPTlsClient
extends AbstractTlsClient {
    public static final Integer EXT_SRP = Integers.valueOf(12);
    protected byte[] identity;
    protected byte[] password;

    public SRPTlsClient(byte[] byArray, byte[] byArray2) {
        this.identity = Arrays.clone(byArray);
        this.password = Arrays.clone(byArray2);
    }

    public SRPTlsClient(TlsCipherFactory tlsCipherFactory, byte[] byArray, byte[] byArray2) {
        super(tlsCipherFactory);
        this.identity = Arrays.clone(byArray);
        this.password = Arrays.clone(byArray2);
    }

    public int[] getCipherSuites() {
        return new int[]{49185, 49182, 49179, 49184, 49181, 49178};
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable<Integer, byte[]> hashtable = super.getClientExtensions();
        if (hashtable == null) {
            hashtable = new Hashtable<Integer, byte[]>();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeOpaque8(this.identity, byteArrayOutputStream);
        hashtable.put(EXT_SRP, byteArrayOutputStream.toByteArray());
        return hashtable;
    }

    public void processServerExtensions(Hashtable hashtable) throws IOException {
        byte[] byArray;
        if (hashtable != null && (byArray = (byte[])hashtable.get(EXT_SRP)) != null && byArray.length > 0) {
            throw new TlsFatalAlert(47);
        }
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49181: 
            case 49184: {
                return this.createSRPKeyExchange(21);
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return this.createSRPKeyExchange(23);
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return this.createSRPKeyExchange(22);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49179: 
            case 49180: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 49181: 
            case 49182: 
            case 49183: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 49184: 
            case 49185: 
            case 49186: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int n2) {
        return new TlsSRPKeyExchange(n2, this.supportedSignatureAlgorithms, this.identity, this.password);
    }
}

