/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CryptoException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.DSA;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Signer;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.NullDigest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA1Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.signers.DSADigestSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.AbstractTlsSigner;

public abstract class TlsDSASigner
extends AbstractTlsSigner {
    public byte[] generateRawSignature(AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        Signer signer = this.makeSigner(new NullDigest(), true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
        signer.update(byArray, 16, 20);
        return signer.generateSignature();
    }

    public boolean verifyRawSignature(byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray2) throws CryptoException {
        Signer signer = this.makeSigner(new NullDigest(), false, asymmetricKeyParameter);
        signer.update(byArray2, 16, 20);
        return signer.verifySignature(byArray);
    }

    public Signer createSigner(AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(new SHA1Digest(), true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
    }

    public Signer createVerifyer(AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(new SHA1Digest(), false, asymmetricKeyParameter);
    }

    protected Signer makeSigner(Digest digest, boolean bl2, CipherParameters cipherParameters) {
        DSADigestSigner dSADigestSigner = new DSADigestSigner(this.createDSAImpl(), digest);
        dSADigestSigner.init(bl2, cipherParameters);
        return dSADigestSigner;
    }

    protected abstract DSA createDSAImpl();
}

