/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Mac;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.LongDigest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.macs.HMac;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.KeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.ProtocolVersion;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.SSL3Mac;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsContext;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TlsMac {
    protected TlsContext context;
    protected byte[] secret;
    protected Mac mac;
    protected int digestBlockSize;
    protected int digestOverhead;

    public TlsMac(TlsContext tlsContext, Digest digest, byte[] byArray, int n2, int n3) {
        this.context = tlsContext;
        KeyParameter keyParameter = new KeyParameter(byArray, n2, n3);
        this.secret = Arrays.clone(keyParameter.getKey());
        if (digest instanceof LongDigest) {
            this.digestBlockSize = 128;
            this.digestOverhead = 16;
        } else {
            this.digestBlockSize = 64;
            this.digestOverhead = 8;
        }
        if (tlsContext.getServerVersion().isSSL()) {
            this.mac = new SSL3Mac(digest);
            if (digest.getDigestSize() == 20) {
                this.digestOverhead = 4;
            }
        } else {
            this.mac = new HMac(digest);
        }
        this.mac.init(keyParameter);
    }

    public byte[] getMACSecret() {
        return this.secret;
    }

    public int getSize() {
        return this.mac.getMacSize();
    }

    public byte[] calculateMac(long l2, short s2, byte[] byArray, int n2, int n3) {
        ProtocolVersion protocolVersion = this.context.getServerVersion();
        boolean bl2 = protocolVersion.isSSL();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bl2 ? 11 : 13);
        try {
            TlsUtils.writeUint64(l2, byteArrayOutputStream);
            TlsUtils.writeUint8(s2, byteArrayOutputStream);
            if (!bl2) {
                TlsUtils.writeVersion(protocolVersion, byteArrayOutputStream);
            }
            TlsUtils.writeUint16(n3, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Internal error during mac calculation");
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.update(byArray, n2, n3);
        byte[] byArray3 = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray3, 0);
        return byArray3;
    }

    public byte[] calculateMacConstantTime(long l2, short s2, byte[] byArray, int n2, int n3, int n4, byte[] byArray2) {
        byte[] byArray3 = this.calculateMac(l2, s2, byArray, n2, n3);
        int n5 = this.context.getServerVersion().isSSL() ? 11 : 13;
        int n6 = this.getDigestBlockCount(n5 + n4) - this.getDigestBlockCount(n5 + n3);
        while (--n6 >= 0) {
            this.mac.update(byArray2, 0, this.digestBlockSize);
        }
        this.mac.update(byArray2[0]);
        this.mac.reset();
        return byArray3;
    }

    private int getDigestBlockCount(int n2) {
        return (n2 + this.digestOverhead) / this.digestBlockSize;
    }
}

