/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.AsymmetricBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CryptoException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Signer;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.signers.GenericSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.signers.RSADigestSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.AbstractTlsSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.CombinedHash;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.ProtocolVersion;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;

public class TlsRSASigner
extends AbstractTlsSigner {
    public byte[] generateRawSignature(AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        AsymmetricBlockCipher asymmetricBlockCipher = this.createRSAImpl();
        asymmetricBlockCipher.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
        return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
    }

    public boolean verifyRawSignature(byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray2) throws CryptoException {
        AsymmetricBlockCipher asymmetricBlockCipher = this.createRSAImpl();
        asymmetricBlockCipher.init(false, asymmetricKeyParameter);
        byte[] byArray3 = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        return Arrays.constantTimeAreEqual(byArray3, byArray2);
    }

    public Signer createSigner(AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(new CombinedHash(), true, new ParametersWithRandom(asymmetricKeyParameter, this.context.getSecureRandom()));
    }

    public Signer createVerifyer(AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(new CombinedHash(), false, asymmetricKeyParameter);
    }

    public boolean isValidPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        return asymmetricKeyParameter instanceof RSAKeyParameters && !asymmetricKeyParameter.isPrivate();
    }

    protected Signer makeSigner(Digest digest, boolean bl2, CipherParameters cipherParameters) {
        Signer signer = ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(this.context.getServerVersion().getEquivalentTLSVersion()) ? new RSADigestSigner(digest) : new GenericSigner(this.createRSAImpl(), digest);
        signer.init(bl2, cipherParameters);
        return signer;
    }

    protected AsymmetricBlockCipher createRSAImpl() {
        return new PKCS1Encoding(new RSABlindedEngine());
    }
}

