/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.InvalidCipherTextException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsContext;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.OutputStream;

public class TlsRSAUtils {
    public static byte[] generateEncryptedPreMasterSecret(TlsContext tlsContext, RSAKeyParameters rSAKeyParameters, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[48];
        tlsContext.getSecureRandom().nextBytes(byArray);
        TlsUtils.writeVersion(tlsContext.getClientVersion(), byArray, 0);
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(new RSABlindedEngine());
        pKCS1Encoding.init(true, new ParametersWithRandom(rSAKeyParameters, tlsContext.getSecureRandom()));
        try {
            byte[] byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
            if (tlsContext.getServerVersion().isSSL()) {
                outputStream.write(byArray2);
            } else {
                TlsUtils.writeOpaque16(byArray2, outputStream);
            }
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new TlsFatalAlert(80);
        }
        return byArray;
    }
}

