/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CryptoException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Signer;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.agreement.srp.SRP6Client;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.agreement.srp.SRP6Util;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA1Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.io.SignerInputStream;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.AbstractTlsKeyExchange;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.Certificate;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.CertificateRequest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.SecurityParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsContext;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsCredentials;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsDSSSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsRSASigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.util.PublicKeyFactory;
import com.zeroturnaround.bundled.org.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;

public class TlsSRPKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsSigner tlsSigner;
    protected byte[] identity;
    protected byte[] password;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected byte[] s = null;
    protected BigInteger B = null;
    protected SRP6Client srpClient = new SRP6Client();

    public TlsSRPKeyExchange(int n2, Vector vector, byte[] byArray, byte[] byArray2) {
        super(n2, vector);
        switch (n2) {
            case 21: {
                this.tlsSigner = null;
                break;
            }
            case 23: {
                this.tlsSigner = new TlsRSASigner();
                break;
            }
            case 22: {
                this.tlsSigner = new TlsDSSSigner();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.keyExchange = n2;
        this.identity = byArray;
        this.password = byArray2;
    }

    public void init(TlsContext tlsContext) {
        super.init(tlsContext);
        if (this.tlsSigner != null) {
            this.tlsSigner.init(tlsContext);
        }
    }

    public void skipServerCredentials() throws IOException {
        if (this.tlsSigner != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        if (this.tlsSigner == null) {
            throw new TlsFatalAlert(10);
        }
        if (certificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate certificate2 = certificate.getCertificateAt(0);
        SubjectPublicKeyInfo subjectPublicKeyInfo = certificate2.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(subjectPublicKeyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43);
        }
        if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
            throw new TlsFatalAlert(46);
        }
        TlsUtils.a(certificate2, 128);
        super.processServerCertificate(certificate);
    }

    public boolean requiresServerKeyExchange() {
        return true;
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        Object object;
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        InputStream inputStream2 = inputStream;
        Signer signer = null;
        if (this.tlsSigner != null) {
            signer = this.initVerifyer(this.tlsSigner, securityParameters);
            inputStream2 = new SignerInputStream(inputStream, signer);
        }
        byte[] byArray = TlsUtils.readOpaque16(inputStream2);
        byte[] byArray2 = TlsUtils.readOpaque16(inputStream2);
        byte[] byArray3 = TlsUtils.readOpaque8(inputStream2);
        byte[] byArray4 = TlsUtils.readOpaque16(inputStream2);
        if (signer != null && !signer.verifySignature((byte[])(object = TlsUtils.readOpaque16(inputStream)))) {
            throw new TlsFatalAlert(51);
        }
        object = new BigInteger(1, byArray);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        this.s = byArray3;
        try {
            this.B = SRP6Util.validatePublicValue((BigInteger)object, new BigInteger(1, byArray4));
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(47);
        }
        this.srpClient.init((BigInteger)object, bigInteger, new SHA1Digest(), this.context.getSecureRandom());
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        byte[] byArray = BigIntegers.asUnsignedByteArray(this.srpClient.generateClientCredentials(this.s, this.identity, this.password));
        TlsUtils.writeOpaque16(byArray, outputStream);
    }

    public byte[] generatePremasterSecret() throws IOException {
        try {
            return BigIntegers.asUnsignedByteArray(this.srpClient.calculateSecret(this.B));
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(47);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.b, 0, securityParameters.b.length);
        signer.update(securityParameters.c, 0, securityParameters.c.length);
        return signer;
    }
}

