/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.StreamCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.KeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsContext;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsMac;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import java.io.IOException;

public class TlsStreamCipher
implements TlsCipher {
    protected TlsContext context;
    protected StreamCipher encryptCipher;
    protected StreamCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsStreamCipher(TlsContext tlsContext, StreamCipher streamCipher, StreamCipher streamCipher2, Digest digest, Digest digest2, int n2) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        boolean bl2 = tlsContext.isServer();
        this.context = tlsContext;
        this.encryptCipher = streamCipher;
        this.decryptCipher = streamCipher2;
        int n3 = 2 * n2 + digest.getDigestSize() + digest2.getDigestSize();
        byte[] byArray = TlsUtils.a(tlsContext, n3);
        int n4 = 0;
        TlsMac tlsMac = new TlsMac(tlsContext, digest, byArray, n4, digest.getDigestSize());
        TlsMac tlsMac2 = new TlsMac(tlsContext, digest2, byArray, n4 += digest.getDigestSize(), digest2.getDigestSize());
        KeyParameter keyParameter3 = new KeyParameter(byArray, n4 += digest2.getDigestSize(), n2);
        KeyParameter keyParameter4 = new KeyParameter(byArray, n4 += n2, n2);
        if ((n4 += n2) != n3) {
            throw new TlsFatalAlert(80);
        }
        if (bl2) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
            this.encryptCipher = streamCipher2;
            this.decryptCipher = streamCipher;
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
            this.encryptCipher = streamCipher;
            this.decryptCipher = streamCipher2;
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
        }
        this.encryptCipher.init(true, keyParameter2);
        this.decryptCipher.init(false, keyParameter);
    }

    public int getPlaintextLimit(int n2) {
        return n2 - this.writeMac.getSize();
    }

    public byte[] encodePlaintext(long l2, short s2, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this.writeMac.calculateMac(l2, s2, byArray, n2, n3);
        byte[] byArray3 = new byte[n3 + byArray2.length];
        this.encryptCipher.processBytes(byArray, n2, n3, byArray3, 0);
        this.encryptCipher.processBytes(byArray2, 0, byArray2.length, byArray3, n3);
        return byArray3;
    }

    public byte[] decodeCiphertext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.readMac.getSize();
        if (n3 < n4) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray2 = new byte[n3];
        this.decryptCipher.processBytes(byArray, n2, n3, byArray2, 0);
        int n5 = n3 - n4;
        byte[] byArray3 = Arrays.copyOfRange(byArray2, n5, n3);
        byte[] byArray4 = this.readMac.calculateMac(l2, s2, byArray2, 0, n5);
        if (!Arrays.constantTimeAreEqual(byArray3, byArray4)) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(byArray2, 0, n5);
    }
}

