/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Extensions;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.KeyUsage;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.MD5Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA1Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA224Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA256Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA384Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA512Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.macs.HMac;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.KeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.Certificate;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.CombinedHash;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.ProtocolVersion;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.SecurityParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsContext;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsDSSSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsECDSASigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsProtocol;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsRSASigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.util.PublicKeyFactory;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import com.zeroturnaround.bundled.org.bouncycastle.util.Integers;
import com.zeroturnaround.bundled.org.bouncycastle.util.Strings;
import com.zeroturnaround.bundled.org.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TlsUtils {
    public static byte[] EMPTY_BYTES = new byte[0];
    public static final Integer EXT_signature_algorithms = Integers.valueOf(13);
    static final byte[] a = new byte[]{67, 76, 78, 84};
    static final byte[] b = new byte[]{83, 82, 86, 82};
    static final byte[][] a = TlsUtils.genConst();

    public static boolean isValidUint8(short s2) {
        return (s2 & 0xFF) == s2;
    }

    public static boolean isValidUint16(int n2) {
        return (n2 & 0xFFFF) == n2;
    }

    public static boolean isValidUint24(int n2) {
        return (n2 & 0xFFFFFF) == n2;
    }

    public static boolean isValidUint32(long l2) {
        return (l2 & 0xFFFFFFFFL) == l2;
    }

    public static boolean isValidUint48(long l2) {
        return (l2 & 0xFFFFFFFFFFFFL) == l2;
    }

    public static boolean isValidUint64(long l2) {
        return true;
    }

    public static void writeUint8(short s2, OutputStream outputStream) throws IOException {
        outputStream.write(s2);
    }

    public static void writeUint8(short s2, byte[] byArray, int n2) {
        byArray[n2] = (byte)s2;
    }

    public static void writeUint16(int n2, OutputStream outputStream) throws IOException {
        outputStream.write(n2 >> 8);
        outputStream.write(n2);
    }

    public static void writeUint16(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >> 8);
        byArray[n3 + 1] = (byte)n2;
    }

    public static void writeUint24(int n2, OutputStream outputStream) throws IOException {
        outputStream.write(n2 >> 16);
        outputStream.write(n2 >> 8);
        outputStream.write(n2);
    }

    public static void writeUint24(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >> 16);
        byArray[n3 + 1] = (byte)(n2 >> 8);
        byArray[n3 + 2] = (byte)n2;
    }

    public static void writeUint32(long l2, OutputStream outputStream) throws IOException {
        outputStream.write((int)(l2 >> 24));
        outputStream.write((int)(l2 >> 16));
        outputStream.write((int)(l2 >> 8));
        outputStream.write((int)l2);
    }

    public static void writeUint32(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 >> 24);
        byArray[n2 + 1] = (byte)(l2 >> 16);
        byArray[n2 + 2] = (byte)(l2 >> 8);
        byArray[n2 + 3] = (byte)l2;
    }

    public static void writeUint48(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 >> 40);
        byArray[n2 + 1] = (byte)(l2 >> 32);
        byArray[n2 + 2] = (byte)(l2 >> 24);
        byArray[n2 + 3] = (byte)(l2 >> 16);
        byArray[n2 + 4] = (byte)(l2 >> 8);
        byArray[n2 + 5] = (byte)l2;
    }

    public static void writeUint64(long l2, OutputStream outputStream) throws IOException {
        outputStream.write((int)(l2 >> 56));
        outputStream.write((int)(l2 >> 48));
        outputStream.write((int)(l2 >> 40));
        outputStream.write((int)(l2 >> 32));
        outputStream.write((int)(l2 >> 24));
        outputStream.write((int)(l2 >> 16));
        outputStream.write((int)(l2 >> 8));
        outputStream.write((int)l2);
    }

    public static void writeUint64(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 >> 56);
        byArray[n2 + 1] = (byte)(l2 >> 48);
        byArray[n2 + 2] = (byte)(l2 >> 40);
        byArray[n2 + 3] = (byte)(l2 >> 32);
        byArray[n2 + 4] = (byte)(l2 >> 24);
        byArray[n2 + 5] = (byte)(l2 >> 16);
        byArray[n2 + 6] = (byte)(l2 >> 8);
        byArray[n2 + 7] = (byte)l2;
    }

    public static void writeOpaque8(byte[] byArray, OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8((short)byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void writeOpaque16(byte[] byArray, OutputStream outputStream) throws IOException {
        TlsUtils.writeUint16(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void writeOpaque24(byte[] byArray, OutputStream outputStream) throws IOException {
        TlsUtils.writeUint24(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void writeUint8Array(short[] sArray, OutputStream outputStream) throws IOException {
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            TlsUtils.writeUint8(sArray[i2], outputStream);
        }
    }

    public static void writeUint16Array(int[] nArray, OutputStream outputStream) throws IOException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            TlsUtils.writeUint16(nArray[i2], outputStream);
        }
    }

    public static short readUint8(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (short)n2;
    }

    public static short readUint8(byte[] byArray, int n2) {
        return byArray[n2];
    }

    public static int readUint16(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n3;
    }

    public static int readUint16(byte[] byArray, int n2) {
        int n3 = (byArray[n2] & 0xFF) << 8;
        return n3 |= byArray[++n2] & 0xFF;
    }

    public static int readUint24(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        return n2 << 16 | n3 << 8 | n4;
    }

    public static int readUint24(byte[] byArray, int n2) {
        int n3 = (byArray[n2] & 0xFF) << 16;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        return n3 |= byArray[++n2] & 0xFF;
    }

    public static long readUint32(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        int n5 = inputStream.read();
        if (n5 < 0) {
            throw new EOFException();
        }
        return (long)n2 << 24 | (long)n3 << 16 | (long)n4 << 8 | (long)n5;
    }

    public static long readUint48(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        int n5 = inputStream.read();
        int n6 = inputStream.read();
        int n7 = inputStream.read();
        if (n7 < 0) {
            throw new EOFException();
        }
        return (long)n2 << 40 | (long)n3 << 32 | (long)n4 << 24 | (long)n5 << 16 | (long)n6 << 8 | (long)n7;
    }

    public static long readUint48(byte[] byArray, int n2) {
        int n3 = TlsUtils.readUint24(byArray, n2);
        int n4 = TlsUtils.readUint24(byArray, n2 + 3);
        return ((long)n3 & 0xFFFFFFFFL) << 24 | (long)n4 & 0xFFFFFFFFL;
    }

    public static byte[] readFully(int n2, InputStream inputStream) throws IOException {
        if (n2 < 1) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[n2];
        if (n2 != Streams.readFully(inputStream, byArray)) {
            throw new EOFException();
        }
        return byArray;
    }

    public static void readFully(byte[] byArray, InputStream inputStream) throws IOException {
        int n2 = byArray.length;
        if (n2 > 0 && n2 != Streams.readFully(inputStream, byArray)) {
            throw new EOFException();
        }
    }

    public static byte[] readOpaque8(InputStream inputStream) throws IOException {
        short s2 = TlsUtils.readUint8(inputStream);
        return TlsUtils.readFully(s2, inputStream);
    }

    public static byte[] readOpaque16(InputStream inputStream) throws IOException {
        int n2 = TlsUtils.readUint16(inputStream);
        return TlsUtils.readFully(n2, inputStream);
    }

    public static byte[] readOpaque24(InputStream inputStream) throws IOException {
        int n2 = TlsUtils.readUint24(inputStream);
        return TlsUtils.readFully(n2, inputStream);
    }

    public static short[] readUint8Array(int n2, InputStream inputStream) throws IOException {
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = TlsUtils.readUint8(inputStream);
        }
        return sArray;
    }

    public static int[] readUint16Array(int n2, InputStream inputStream) throws IOException {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = TlsUtils.readUint16(inputStream);
        }
        return nArray;
    }

    public static ProtocolVersion readVersion(byte[] byArray, int n2) throws IOException {
        return ProtocolVersion.get(byArray[n2] & 0xFF, byArray[n2 + 1] & 0xFF);
    }

    public static ProtocolVersion readVersion(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return ProtocolVersion.get(n2, n3);
    }

    public static int readVersionRaw(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n3;
    }

    public static void writeGMTUnixTime(byte[] byArray, int n2) {
        int n3 = (int)(System.currentTimeMillis() / 1000L);
        byArray[n2] = (byte)(n3 >> 24);
        byArray[n2 + 1] = (byte)(n3 >> 16);
        byArray[n2 + 2] = (byte)(n3 >> 8);
        byArray[n2 + 3] = (byte)n3;
    }

    public static void writeVersion(ProtocolVersion protocolVersion, OutputStream outputStream) throws IOException {
        outputStream.write(protocolVersion.getMajorVersion());
        outputStream.write(protocolVersion.getMinorVersion());
    }

    public static void writeVersion(ProtocolVersion protocolVersion, byte[] byArray, int n2) throws IOException {
        byArray[n2] = (byte)protocolVersion.getMajorVersion();
        byArray[n2 + 1] = (byte)protocolVersion.getMinorVersion();
    }

    public static Vector getDefaultDSSSignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 2));
    }

    public static Vector getDefaultECDSASignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 3));
    }

    public static Vector getDefaultRSASignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 1));
    }

    public static boolean isSignatureAlgorithmsExtensionAllowed(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static void addSignatureAlgorithmsExtension(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_signature_algorithms, TlsUtils.createSignatureAlgorithmsExtension(vector));
    }

    public static Vector getSignatureAlgorithmsExtension(Hashtable hashtable) throws IOException {
        if (hashtable == null) {
            return null;
        }
        byte[] byArray = (byte[])hashtable.get(EXT_signature_algorithms);
        if (byArray == null) {
            return null;
        }
        return TlsUtils.readSignatureAlgorithmsExtension(byArray);
    }

    public static byte[] createSignatureAlgorithmsExtension(Vector vector) throws IOException {
        if (vector == null || vector.size() < 1 || vector.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(2 * vector.size(), byteArrayOutputStream);
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)vector.elementAt(i2);
            signatureAndHashAlgorithm.encode(byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Vector readSignatureAlgorithmsExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionValue' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int n3 = n2 / 2;
        Vector<SignatureAndHashAlgorithm> vector = new Vector<SignatureAndHashAlgorithm>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.parse(byteArrayInputStream);
            vector.addElement(signatureAndHashAlgorithm);
        }
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return vector;
    }

    public static byte[] PRF(TlsContext tlsContext, byte[] byArray, String string, byte[] byArray2, int n2) {
        ProtocolVersion protocolVersion = tlsContext.getServerVersion();
        if (protocolVersion.isSSL()) {
            throw new IllegalStateException("No PRF available for SSLv3 session");
        }
        byte[] byArray3 = Strings.toByteArray(string);
        byte[] byArray4 = TlsUtils.a(byArray3, byArray2);
        int n3 = tlsContext.getSecurityParameters().getPrfAlgorithm();
        if (n3 == 0) {
            if (!ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion())) {
                return TlsUtils.a(byArray, byArray3, byArray4, n2);
            }
            n3 = 1;
        }
        Digest digest = TlsUtils.createPRFHash(n3);
        byte[] byArray5 = new byte[n2];
        TlsUtils.a(digest, byArray, byArray4, byArray5);
        return byArray5;
    }

    static byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        int n3 = (byArray.length + 1) / 2;
        byte[] byArray4 = new byte[n3];
        byte[] byArray5 = new byte[n3];
        System.arraycopy(byArray, 0, byArray4, 0, n3);
        System.arraycopy(byArray, byArray.length - n3, byArray5, 0, n3);
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = new byte[n2];
        TlsUtils.a(new MD5Digest(), byArray4, byArray3, byArray6);
        TlsUtils.a(new SHA1Digest(), byArray5, byArray3, byArray7);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = i2;
            byArray6[n4] = (byte)(byArray6[n4] ^ byArray7[i2]);
        }
        return byArray6;
    }

    static byte[] a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static void a(Digest digest, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        HMac hMac = new HMac(digest);
        KeyParameter keyParameter = new KeyParameter(byArray);
        byte[] byArray4 = byArray2;
        int n2 = digest.getDigestSize();
        int n3 = (byArray3.length + n2 - 1) / n2;
        byte[] byArray5 = new byte[hMac.getMacSize()];
        byte[] byArray6 = new byte[hMac.getMacSize()];
        for (int i2 = 0; i2 < n3; ++i2) {
            hMac.init(keyParameter);
            hMac.update(byArray4, 0, byArray4.length);
            hMac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            hMac.init(keyParameter);
            hMac.update(byArray4, 0, byArray4.length);
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, n2 * i2, Math.min(n2, byArray3.length - n2 * i2));
        }
    }

    static void a(com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate certificate, int n2) throws IOException {
        int n3;
        KeyUsage keyUsage;
        Extensions extensions = certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (keyUsage = KeyUsage.fromExtensions(extensions)) != null && ((n3 = keyUsage.getBytes()[0] & 0xFF) & n2) != n2) {
            throw new TlsFatalAlert(46);
        }
    }

    static byte[] a(TlsContext tlsContext, int n2) {
        SecurityParameters securityParameters = tlsContext.getSecurityParameters();
        byte[] byArray = securityParameters.getMasterSecret();
        byte[] byArray2 = TlsUtils.a(securityParameters.getServerRandom(), securityParameters.getClientRandom());
        if (tlsContext.getServerVersion().isSSL()) {
            return TlsUtils.a(byArray, byArray2, n2);
        }
        return TlsUtils.PRF(tlsContext, byArray, "key expansion", byArray2, n2);
    }

    static byte[] a(byte[] byArray, byte[] byArray2, int n2) {
        byte[] byArray3;
        MD5Digest mD5Digest = new MD5Digest();
        SHA1Digest sHA1Digest = new SHA1Digest();
        int n3 = mD5Digest.getDigestSize();
        byte[] byArray4 = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray5 = new byte[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            byArray3 = a[n4];
            sHA1Digest.update(byArray3, 0, byArray3.length);
            sHA1Digest.update(byArray, 0, byArray.length);
            sHA1Digest.update(byArray2, 0, byArray2.length);
            sHA1Digest.doFinal(byArray4, 0);
            mD5Digest.update(byArray, 0, byArray.length);
            mD5Digest.update(byArray4, 0, byArray4.length);
            mD5Digest.doFinal(byArray5, n5);
            n5 += n3;
            ++n4;
        }
        byArray3 = new byte[n2];
        System.arraycopy(byArray5, 0, byArray3, 0, n2);
        return byArray3;
    }

    static byte[] a(TlsContext tlsContext, byte[] byArray) {
        SecurityParameters securityParameters = tlsContext.getSecurityParameters();
        byte[] byArray2 = TlsUtils.a(securityParameters.getClientRandom(), securityParameters.getServerRandom());
        if (tlsContext.getServerVersion().isSSL()) {
            return TlsUtils.b(byArray, byArray2);
        }
        return TlsUtils.PRF(tlsContext, byArray, "master secret", byArray2, 48);
    }

    static byte[] b(byte[] byArray, byte[] byArray2) {
        MD5Digest mD5Digest = new MD5Digest();
        SHA1Digest sHA1Digest = new SHA1Digest();
        int n2 = mD5Digest.getDigestSize();
        byte[] byArray3 = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray4 = new byte[n2 * 3];
        int n3 = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            byte[] byArray5 = a[i2];
            sHA1Digest.update(byArray5, 0, byArray5.length);
            sHA1Digest.update(byArray, 0, byArray.length);
            sHA1Digest.update(byArray2, 0, byArray2.length);
            sHA1Digest.doFinal(byArray3, 0);
            mD5Digest.update(byArray, 0, byArray.length);
            mD5Digest.update(byArray3, 0, byArray3.length);
            mD5Digest.doFinal(byArray4, n3);
            n3 += n2;
        }
        return byArray4;
    }

    static byte[] a(TlsContext tlsContext, String string, byte[] byArray) {
        if (tlsContext.getServerVersion().isSSL()) {
            return byArray;
        }
        SecurityParameters securityParameters = tlsContext.getSecurityParameters();
        byte[] byArray2 = securityParameters.getMasterSecret();
        int n2 = securityParameters.getVerifyDataLength();
        return TlsUtils.PRF(tlsContext, byArray2, string, byArray, n2);
    }

    public static final Digest createHash(int n2) {
        switch (n2) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    public static final Digest cloneHash(int n2, Digest digest) {
        switch (n2) {
            case 1: {
                return new MD5Digest((MD5Digest)digest);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)digest);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)digest);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)digest);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)digest);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)digest);
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    public static final Digest createPRFHash(int n2) {
        switch (n2) {
            case 0: {
                return new CombinedHash();
            }
        }
        return TlsUtils.createHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(n2));
    }

    public static final Digest clonePRFHash(int n2, Digest digest) {
        switch (n2) {
            case 0: {
                return new CombinedHash((CombinedHash)digest);
            }
        }
        return TlsUtils.cloneHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(n2), digest);
    }

    public static final short getHashAlgorithmForPRFAlgorithm(int n2) {
        switch (n2) {
            case 0: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm");
    }

    public static ASN1ObjectIdentifier getOIDForHashAlgorithm(int n2) {
        switch (n2) {
            case 1: {
                return PKCSObjectIdentifiers.md5;
            }
            case 2: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case 3: {
                return NISTObjectIdentifiers.id_sha224;
            }
            case 4: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case 5: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case 6: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    static short a(Certificate certificate, Certificate certificate2) throws IOException {
        if (certificate.isEmpty()) {
            return -1;
        }
        com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate certificate3 = certificate.getCertificateAt(0);
        SubjectPublicKeyInfo subjectPublicKeyInfo = certificate3.getSubjectPublicKeyInfo();
        try {
            AsymmetricKeyParameter asymmetricKeyParameter = PublicKeyFactory.createKey(subjectPublicKeyInfo);
            if (asymmetricKeyParameter.isPrivate()) {
                throw new TlsFatalAlert(80);
            }
            if (asymmetricKeyParameter instanceof RSAKeyParameters) {
                TlsUtils.a(certificate3, 128);
                return 1;
            }
            if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
                TlsUtils.a(certificate3, 128);
                return 2;
            }
            if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
                TlsUtils.a(certificate3, 128);
                return 64;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new TlsFatalAlert(43);
    }

    public static boolean hasSigningCapability(short s2) {
        switch (s2) {
            case 1: 
            case 2: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    public static TlsSigner createTlsSigner(short s2) {
        switch (s2) {
            case 2: {
                return new TlsDSSSigner();
            }
            case 64: {
                return new TlsECDSASigner();
            }
            case 1: {
                return new TlsRSASigner();
            }
        }
        throw new IllegalArgumentException("'clientCertificateType' is not a type with signing capability");
    }

    private static byte[][] genConst() {
        int n2 = 10;
        byte[][] byArrayArray = new byte[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] byArray = new byte[i2 + 1];
            Arrays.fill(byArray, (byte)(65 + i2));
            byArrayArray[i2] = byArray;
        }
        return byArrayArray;
    }

    private static Vector vectorOfOne(Object object) {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(object);
        return vector;
    }
}

