/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.ec;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.nist.NISTNamedCurves;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.sec.SECNamedCurves;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x9.X962NamedCurves;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x9.X9ECParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECDomainParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.zeroturnaround.bundled.org.bouncycastle.jce.ECNamedCurveTable;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.zeroturnaround.bundled.org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import com.zeroturnaround.bundled.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.zeroturnaround.bundled.org.bouncycastle.jce.spec.ECParameterSpec;
import com.zeroturnaround.bundled.org.bouncycastle.util.Integers;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class KeyPairGeneratorSpi$EC
extends KeyPairGeneratorSpi {
    ECKeyGenerationParameters a;
    ECKeyPairGenerator a;
    ECParameterSpec a;
    int a;
    int b = 50;
    SecureRandom a;
    boolean a;
    String a;
    ProviderConfiguration a = false;
    private static Hashtable ecParameters = new Hashtable();

    public KeyPairGeneratorSpi$EC() {
        super("EC");
        this.a = "EC";
        this.a = BouncyCastleProvider.CONFIGURATION;
    }

    public KeyPairGeneratorSpi$EC(String string, ProviderConfiguration providerConfiguration) {
        super(string);
        this.a = string;
        this.a = providerConfiguration;
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.a = n2;
        this.a = secureRandom;
        this.a = (ECParameterSpec)ecParameters.get(Integers.valueOf(n2));
        if (this.a == null) {
            throw new InvalidParameterException("unknown key size.");
        }
        this.a = new ECKeyGenerationParameters(new ECDomainParameters(this.a.getCurve(), this.a.getG(), this.a.getN()), secureRandom);
        this.a.init(this.a);
        this.a = true;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            ECParameterSpec eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            this.a = (ECParameterSpec)algorithmParameterSpec;
            this.a = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()), secureRandom);
            this.a.init(this.a);
            this.a = true;
        } else if (algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec) {
            String string = ((ECNamedCurveGenParameterSpec)algorithmParameterSpec).getName();
            X9ECParameters x9ECParameters = X962NamedCurves.getByName(string);
            if (x9ECParameters == null) {
                x9ECParameters = SECNamedCurves.getByName(string);
                if (x9ECParameters == null) {
                    x9ECParameters = NISTNamedCurves.getByName(string);
                }
                if (x9ECParameters == null) {
                    x9ECParameters = TeleTrusTNamedCurves.getByName(string);
                }
                if (x9ECParameters == null) {
                    try {
                        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
                        x9ECParameters = X962NamedCurves.getByOID(aSN1ObjectIdentifier);
                        if (x9ECParameters == null) {
                            x9ECParameters = SECNamedCurves.getByOID(aSN1ObjectIdentifier);
                        }
                        if (x9ECParameters == null) {
                            x9ECParameters = NISTNamedCurves.getByOID(aSN1ObjectIdentifier);
                        }
                        if (x9ECParameters == null) {
                            x9ECParameters = TeleTrusTNamedCurves.getByOID(aSN1ObjectIdentifier);
                        }
                        if (x9ECParameters == null) {
                            throw new InvalidAlgorithmParameterException("unknown curve OID: " + string);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidAlgorithmParameterException("unknown curve name: " + string);
                    }
                }
            }
            this.a = new ECNamedCurveParameterSpec(string, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), null);
            this.a = new ECKeyGenerationParameters(new ECDomainParameters(this.a.getCurve(), this.a.getG(), this.a.getN()), secureRandom);
            this.a.init(this.a);
            this.a = true;
        } else if (algorithmParameterSpec == null && this.a.getEcImplicitlyCa() != null) {
            ECParameterSpec eCParameterSpec = this.a.getEcImplicitlyCa();
            this.a = (ECParameterSpec)algorithmParameterSpec;
            this.a = new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN()), secureRandom);
            this.a.init(this.a);
            this.a = true;
        } else {
            if (algorithmParameterSpec == null && this.a.getEcImplicitlyCa() == null) {
                throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
            }
            throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
        }
    }

    public KeyPair generateKeyPair() {
        if (!this.a) {
            throw new IllegalStateException("EC Key Pair Generator not initialised");
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.a.generateKeyPair();
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        if (this.a == null) {
            return new KeyPair(new BCECPublicKey(this.a, eCPublicKeyParameters, this.a), new BCECPrivateKey(this.a, eCPrivateKeyParameters, this.a));
        }
        ECParameterSpec eCParameterSpec = this.a;
        BCECPublicKey bCECPublicKey = new BCECPublicKey(this.a, eCPublicKeyParameters, eCParameterSpec, this.a);
        return new KeyPair(bCECPublicKey, new BCECPrivateKey(this.a, eCPrivateKeyParameters, bCECPublicKey, eCParameterSpec, this.a));
    }

    static {
        ecParameters.put(Integers.valueOf(192), ECNamedCurveTable.getParameterSpec("prime192v1"));
        ecParameters.put(Integers.valueOf(239), ECNamedCurveTable.getParameterSpec("prime239v1"));
        ecParameters.put(Integers.valueOf(256), ECNamedCurveTable.getParameterSpec("prime256v1"));
    }
}

