/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.ecgost;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Encodable;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERBitString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERInteger;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERNull;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DEROutputStream;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x9.X962Parameters;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x9.X9ECParameters;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECDomainParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PublicKey;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.zeroturnaround.bundled.org.bouncycastle.jce.interfaces.ECPointEncoder;
import com.zeroturnaround.bundled.org.bouncycastle.jce.interfaces.ECPrivateKey;
import com.zeroturnaround.bundled.org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.zeroturnaround.bundled.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.zeroturnaround.bundled.org.bouncycastle.jce.spec.ECParameterSpec;
import com.zeroturnaround.bundled.org.bouncycastle.jce.spec.ECPrivateKeySpec;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECCurve;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECCurve$F2m;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECCurve$Fp;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint$F2m;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint$Fp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.Enumeration;

public class BCECGOST3410PrivateKey
implements ECPointEncoder,
ECPrivateKey,
PKCS12BagAttributeCarrier {
    private String algorithm = "ECGOST3410";
    private boolean withCompression;
    private transient BigInteger d;
    private transient ECParameterSpec ecSpec;
    private transient DERBitString publicKey;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier = new PKCS12BagAttributeCarrierImpl();

    protected BCECGOST3410PrivateKey() {
    }

    public BCECGOST3410PrivateKey(ECPrivateKeySpec eCPrivateKeySpec) {
        this.d = eCPrivateKeySpec.getD();
        this.ecSpec = eCPrivateKeySpec.getParams();
    }

    public BCECGOST3410PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, BCECGOST3410PublicKey bCECGOST3410PublicKey, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        this.ecSpec = eCParameterSpec == null ? new ECParameterSpec(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed()) : eCParameterSpec;
        this.publicKey = this.getPublicKeyDetails(bCECGOST3410PublicKey);
    }

    public BCECGOST3410PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters) {
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        this.ecSpec = null;
    }

    public BCECGOST3410PrivateKey(String string, BCECGOST3410PrivateKey bCECGOST3410PrivateKey) {
        this.algorithm = string;
        this.d = bCECGOST3410PrivateKey.d;
        this.ecSpec = bCECGOST3410PrivateKey.ecSpec;
        this.withCompression = bCECGOST3410PrivateKey.withCompression;
        this.publicKey = bCECGOST3410PrivateKey.publicKey;
        this.attrCarrier = bCECGOST3410PrivateKey.attrCarrier;
    }

    BCECGOST3410PrivateKey(PrivateKeyInfo privateKeyInfo) {
        this.populateFromPrivKeyInfo(privateKeyInfo);
    }

    private void populateFromPrivKeyInfo(PrivateKeyInfo privateKeyInfo) {
        ASN1Object aSN1Object;
        X962Parameters x962Parameters = X962Parameters.getInstance(privateKeyInfo.getAlgorithmId().getParameters());
        if (x962Parameters.isNamedCurve()) {
            aSN1Object = (ASN1ObjectIdentifier)x962Parameters.getParameters();
            ECDomainParameters eCDomainParameters = ECGOST3410NamedCurves.getByOID((ASN1ObjectIdentifier)aSN1Object);
            this.ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName((ASN1ObjectIdentifier)aSN1Object), eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
        } else if (x962Parameters.isImplicitlyCA()) {
            this.ecSpec = null;
        } else {
            aSN1Object = X9ECParameters.getInstance(x962Parameters.getParameters());
            this.ecSpec = new ECParameterSpec(((X9ECParameters)aSN1Object).getCurve(), ((X9ECParameters)aSN1Object).getG(), ((X9ECParameters)aSN1Object).getN(), ((X9ECParameters)aSN1Object).getH(), ((X9ECParameters)aSN1Object).getSeed());
        }
        if (privateKeyInfo.getPrivateKey() instanceof ASN1Integer) {
            aSN1Object = ASN1Integer.getInstance(privateKeyInfo.getPrivateKey());
            this.d = ((DERInteger)aSN1Object).getValue();
        } else {
            aSN1Object = new ECPrivateKeyStructure((ASN1Sequence)privateKeyInfo.getPrivateKey());
            this.d = ((ECPrivateKeyStructure)aSN1Object).getKey();
            this.publicKey = ((ECPrivateKeyStructure)aSN1Object).getPublicKey();
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        Object object;
        Object object2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X962Parameters x962Parameters = null;
        if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
            object2 = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)this.ecSpec).getName());
            x962Parameters = new X962Parameters((ASN1ObjectIdentifier)object2);
        } else if (this.ecSpec == null) {
            x962Parameters = new X962Parameters(DERNull.INSTANCE);
        } else {
            ECPoint eCPoint;
            object2 = this.ecSpec;
            object = ((ECParameterSpec)object2).getG().getCurve();
            if (object instanceof ECCurve$Fp) {
                eCPoint = new ECPoint$Fp((ECCurve)object, ((ECParameterSpec)object2).getG().getX(), ((ECParameterSpec)object2).getG().getY(), this.withCompression);
            } else if (object instanceof ECCurve$F2m) {
                eCPoint = new ECPoint$F2m((ECCurve)object, ((ECParameterSpec)object2).getG().getX(), ((ECParameterSpec)object2).getG().getY(), this.withCompression);
            } else {
                throw new UnsupportedOperationException("Subclass of ECPoint " + object.getClass().toString() + "not supported");
            }
            X9ECParameters x9ECParameters = new X9ECParameters(((ECParameterSpec)object2).getCurve(), eCPoint, ((ECParameterSpec)object2).getN(), ((ECParameterSpec)object2).getH(), ((ECParameterSpec)object2).getSeed());
            x962Parameters = new X962Parameters(x9ECParameters);
        }
        object = this.publicKey != null ? new ECPrivateKeyStructure(this.getD(), this.publicKey, x962Parameters) : new ECPrivateKeyStructure(this.getD(), x962Parameters);
        try {
            object2 = this.algorithm.equals("ECGOST3410") ? new PrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, (ASN1Encodable)x962Parameters), (ASN1Encodable)object) : new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)x962Parameters), (ASN1Encodable)object);
            return KeyUtil.getEncodedPrivateKeyInfo((PrivateKeyInfo)object2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public ECParameterSpec getParameters() {
        return this.ecSpec;
    }

    public BigInteger getD() {
        return this.d;
    }

    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    ECParameterSpec a() {
        if (this.ecSpec != null) {
            return this.ecSpec;
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCECGOST3410PrivateKey)) {
            return false;
        }
        BCECGOST3410PrivateKey bCECGOST3410PrivateKey = (BCECGOST3410PrivateKey)object;
        return this.getD().equals(bCECGOST3410PrivateKey.getD()) && this.a().equals(bCECGOST3410PrivateKey.a());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.a().hashCode();
    }

    private DERBitString getPublicKeyDetails(BCECGOST3410PublicKey bCECGOST3410PublicKey) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(bCECGOST3410PublicKey.getEncoded()));
            return subjectPublicKeyInfo.getPublicKeyData();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.populateFromPrivKeyInfo(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

