/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.gost;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.generators.GOST3410ParametersGenerator;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.GOST3410Parameters;
import com.zeroturnaround.bundled.org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import com.zeroturnaround.bundled.org.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public abstract class AlgorithmParameterGeneratorSpi
extends java.security.AlgorithmParameterGeneratorSpi {
    protected SecureRandom random;
    protected int strength = 1024;

    protected void engineInit(int n2, SecureRandom secureRandom) {
        this.strength = n2;
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for GOST3410 parameter generation.");
    }

    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters algorithmParameters;
        GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
        if (this.random != null) {
            gOST3410ParametersGenerator.init(this.strength, 2, this.random);
        } else {
            gOST3410ParametersGenerator.init(this.strength, 2, new SecureRandom());
        }
        GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
        try {
            algorithmParameters = AlgorithmParameters.getInstance("GOST3410", "BC");
            algorithmParameters.init(new GOST3410ParameterSpec(new GOST3410PublicKeyParameterSetSpec(gOST3410Parameters.getP(), gOST3410Parameters.getQ(), gOST3410Parameters.getA())));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return algorithmParameters;
    }
}

