/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DEROutputStream;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.rsa.AlgorithmParametersSpi;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PSSParameterSpec;

public class AlgorithmParametersSpi$PSS
extends AlgorithmParametersSpi {
    PSSParameterSpec a;

    protected byte[] engineGetEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        PSSParameterSpec pSSParameterSpec = this.a;
        RSASSAPSSparams rSASSAPSSparams = new RSASSAPSSparams(RSASSAPSSparams.DEFAULT_HASH_ALGORITHM, RSASSAPSSparams.DEFAULT_MASK_GEN_FUNCTION, new ASN1Integer(pSSParameterSpec.getSaltLength()), RSASSAPSSparams.DEFAULT_TRAILER_FIELD);
        dEROutputStream.writeObject(rSASSAPSSparams);
        dEROutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if (string.equalsIgnoreCase("X.509") || string.equalsIgnoreCase("ASN.1")) {
            return this.engineGetEncoded();
        }
        return null;
    }

    protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz == (AlgorithmParametersSpi.a == null ? (AlgorithmParametersSpi.a = AlgorithmParametersSpi.a("java.security.spec.PSSParameterSpec")) : AlgorithmParametersSpi.a) && this.a != null) {
            return this.a;
        }
        throw new InvalidParameterSpecException("unknown parameter spec passed to PSS parameters object.");
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            throw new InvalidParameterSpecException("PSSParameterSpec required to initialise an PSS algorithm parameters object");
        }
        this.a = (PSSParameterSpec)algorithmParameterSpec;
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            RSASSAPSSparams rSASSAPSSparams = RSASSAPSSparams.getInstance(byArray);
            this.a = new PSSParameterSpec(rSASSAPSSparams.getSaltLength().intValue());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a valid PSS Parameter encoding.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("Not a valid PSS Parameter encoding.");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (!this.isASN1FormatString(string) && !string.equalsIgnoreCase("X.509")) {
            throw new IOException("Unknown parameter format " + string);
        }
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return "PSS Parameters";
    }
}

