/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.AsymmetricBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CryptoException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA1Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA224Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA256Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA384Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA512Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.signers.PSSSigner;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$NullPssDigest;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;

public class PSSSignatureSpi
extends Signature {
    private AlgorithmParameters engineParams;
    private PSSParameterSpec paramSpec;
    private AsymmetricBlockCipher signer;
    private Digest contentDigest;
    private Digest mgfDigest;
    private int saltLength;
    private byte trailer;
    private boolean isRaw;
    private PSSSigner pss;

    private byte getTrailer(int n2) {
        if (n2 == 1) {
            return -68;
        }
        throw new IllegalArgumentException("unknown trailer field");
    }

    private void setupContentDigest() {
        this.contentDigest = this.isRaw ? new PSSSignatureSpi$NullPssDigest(this, this.mgfDigest) : this.mgfDigest;
    }

    protected PSSSignatureSpi(String string, AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        super(string);
        this.signer = asymmetricBlockCipher;
        this.mgfDigest = digest;
        this.saltLength = digest != null ? digest.getDigestSize() : 20;
        if (this.paramSpec != null) {
            this.saltLength = this.paramSpec.getSaltLength();
        }
        this.isRaw = false;
        this.setupContentDigest();
    }

    protected PSSSignatureSpi(String string, AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, boolean bl2) {
        super(string);
        this.signer = asymmetricBlockCipher;
        this.mgfDigest = digest;
        this.saltLength = digest != null ? digest.getDigestSize() : 20;
        if (this.paramSpec != null) {
            this.saltLength = this.paramSpec.getSaltLength();
        }
        this.isRaw = bl2;
        this.setupContentDigest();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPublicKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.contentDigest, this.mgfDigest, this.saltLength);
        this.pss.init(false, RSAUtil.a((RSAPublicKey)publicKey));
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.contentDigest, this.mgfDigest, this.saltLength);
        this.pss.init(true, new ParametersWithRandom(RSAUtil.a((RSAPrivateKey)privateKey), secureRandom));
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.contentDigest, this.mgfDigest, this.saltLength);
        this.pss.init(true, RSAUtil.a((RSAPrivateKey)privateKey));
    }

    protected void engineUpdate(byte by2) throws SignatureException {
        this.pss.update(by2);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.pss.update(byArray, n2, n3);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            return this.pss.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new SignatureException(cryptoException.getMessage());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.pss.verifySignature(byArray);
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterException {
        if (algorithmParameterSpec instanceof PSSParameterSpec) {
            PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
            this.engineParams = null;
            this.paramSpec = pSSParameterSpec;
            this.saltLength = this.paramSpec.getSaltLength();
            if (this.mgfDigest == null) {
                switch (this.saltLength) {
                    case 20: {
                        this.mgfDigest = new SHA1Digest();
                        break;
                    }
                    case 28: {
                        this.mgfDigest = new SHA224Digest();
                        break;
                    }
                    case 32: {
                        this.mgfDigest = new SHA256Digest();
                        break;
                    }
                    case 48: {
                        this.mgfDigest = new SHA384Digest();
                        break;
                    }
                    case 64: {
                        this.mgfDigest = new SHA512Digest();
                    }
                }
                this.setupContentDigest();
            }
        } else {
            throw new InvalidParameterException("Only PSSParameterSpec supported");
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("PSS", "BC");
                this.engineParams.init(new PSSParameterSpec(this.saltLength));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.engineParams;
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }
}

