/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.keystore.bc;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.PBEParametersGenerator;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA1Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.io.MacInputStream;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.io.MacOutputStream;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.macs.HMac;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.keystore.bc.BcKeyStoreSpi$StoreEntry;
import com.zeroturnaround.bundled.org.bouncycastle.jce.interfaces.BCKeyStore;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import com.zeroturnaround.bundled.org.bouncycastle.util.io.TeeOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class BcKeyStoreSpi
extends KeyStoreSpi
implements BCKeyStore {
    private static final int STORE_VERSION = 2;
    private static final int STORE_SALT_SIZE = 20;
    private static final String STORE_CIPHER = "PBEWithSHAAndTwofish-CBC";
    private static final int KEY_SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 1024;
    private static final String KEY_CIPHER = "PBEWithSHAAnd3-KeyTripleDES-CBC";
    protected Hashtable table = new Hashtable();
    protected SecureRandom random = new SecureRandom();
    protected int version;

    public BcKeyStoreSpi(int n2) {
        this.version = n2;
    }

    private void encodeCertificate(Certificate certificate, DataOutputStream dataOutputStream) throws IOException {
        try {
            byte[] byArray = certificate.getEncoded();
            dataOutputStream.writeUTF(certificate.getType());
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IOException(certificateEncodingException.toString());
        }
    }

    private Certificate decodeCertificate(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        byte[] byArray = new byte[dataInputStream.readInt()];
        dataInputStream.readFully(byArray);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(string, "BC");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new IOException(noSuchProviderException.toString());
        }
        catch (CertificateException certificateException) {
            throw new IOException(certificateException.toString());
        }
    }

    private void encodeKey(Key key, DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray = key.getEncoded();
        if (key instanceof PrivateKey) {
            dataOutputStream.write(0);
        } else if (key instanceof PublicKey) {
            dataOutputStream.write(1);
        } else {
            dataOutputStream.write(2);
        }
        dataOutputStream.writeUTF(key.getFormat());
        dataOutputStream.writeUTF(key.getAlgorithm());
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    private Key decodeKey(DataInputStream dataInputStream) throws IOException {
        EncodedKeySpec encodedKeySpec;
        int n2 = dataInputStream.read();
        String string = dataInputStream.readUTF();
        String string2 = dataInputStream.readUTF();
        byte[] byArray = new byte[dataInputStream.readInt()];
        dataInputStream.readFully(byArray);
        if (string.equals("PKCS#8") || string.equals("PKCS8")) {
            encodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        } else if (string.equals("X.509") || string.equals("X509")) {
            encodedKeySpec = new X509EncodedKeySpec(byArray);
        } else {
            if (string.equals("RAW")) {
                return new SecretKeySpec(byArray, string2);
            }
            throw new IOException("Key format " + string + " not recognised!");
        }
        try {
            switch (n2) {
                case 0: {
                    return KeyFactory.getInstance(string2, "BC").generatePrivate(encodedKeySpec);
                }
                case 1: {
                    return KeyFactory.getInstance(string2, "BC").generatePublic(encodedKeySpec);
                }
                case 2: {
                    return SecretKeyFactory.getInstance(string2, "BC").generateSecret(encodedKeySpec);
                }
            }
            throw new IOException("Key type " + n2 + " not recognised!");
        }
        catch (Exception exception) {
            throw new IOException("Exception creating key: " + exception.toString());
        }
    }

    protected Cipher makePBECipher(String string, int n2, char[] cArray, byte[] byArray, int n3) throws IOException {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "BC");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n3);
            Cipher cipher = Cipher.getInstance(string, "BC");
            cipher.init(n2, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            return cipher;
        }
        catch (Exception exception) {
            throw new IOException("Error initialising store of key store: " + exception);
        }
    }

    public void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    public Enumeration engineAliases() {
        return this.table.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.table.get(string) != null;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        Object v2 = this.table.get(string);
        if (v2 == null) {
            return;
        }
        this.table.remove(string);
    }

    public Certificate engineGetCertificate(String string) {
        BcKeyStoreSpi$StoreEntry bcKeyStoreSpi$StoreEntry = (BcKeyStoreSpi$StoreEntry)this.table.get(string);
        if (bcKeyStoreSpi$StoreEntry != null) {
            if (bcKeyStoreSpi$StoreEntry.a() == 1) {
                return (Certificate)bcKeyStoreSpi$StoreEntry.a();
            }
            Certificate[] certificateArray = bcKeyStoreSpi$StoreEntry.a();
            if (certificateArray != null) {
                return certificateArray[0];
            }
        }
        return null;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            BcKeyStoreSpi$StoreEntry bcKeyStoreSpi$StoreEntry = (BcKeyStoreSpi$StoreEntry)enumeration.nextElement();
            if (!(bcKeyStoreSpi$StoreEntry.a() instanceof Certificate ? ((Certificate)(object = (Certificate)bcKeyStoreSpi$StoreEntry.a())).equals(certificate) : (object = bcKeyStoreSpi$StoreEntry.a()) != null && ((Certificate)object[0]).equals(certificate))) continue;
            return bcKeyStoreSpi$StoreEntry.a();
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        BcKeyStoreSpi$StoreEntry bcKeyStoreSpi$StoreEntry = (BcKeyStoreSpi$StoreEntry)this.table.get(string);
        if (bcKeyStoreSpi$StoreEntry != null) {
            return bcKeyStoreSpi$StoreEntry.a();
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        BcKeyStoreSpi$StoreEntry bcKeyStoreSpi$StoreEntry = (BcKeyStoreSpi$StoreEntry)this.table.get(string);
        if (bcKeyStoreSpi$StoreEntry != null) {
            return bcKeyStoreSpi$StoreEntry.a();
        }
        return null;
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        BcKeyStoreSpi$StoreEntry bcKeyStoreSpi$StoreEntry = (BcKeyStoreSpi$StoreEntry)this.table.get(string);
        if (bcKeyStoreSpi$StoreEntry == null || bcKeyStoreSpi$StoreEntry.a() == 1) {
            return null;
        }
        return (Key)bcKeyStoreSpi$StoreEntry.a(cArray);
    }

    public boolean engineIsCertificateEntry(String string) {
        BcKeyStoreSpi$StoreEntry bcKeyStoreSpi$StoreEntry = (BcKeyStoreSpi$StoreEntry)this.table.get(string);
        return bcKeyStoreSpi$StoreEntry != null && bcKeyStoreSpi$StoreEntry.a() == 1;
    }

    public boolean engineIsKeyEntry(String string) {
        BcKeyStoreSpi$StoreEntry bcKeyStoreSpi$StoreEntry = (BcKeyStoreSpi$StoreEntry)this.table.get(string);
        return bcKeyStoreSpi$StoreEntry != null && bcKeyStoreSpi$StoreEntry.a() != 1;
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        BcKeyStoreSpi$StoreEntry bcKeyStoreSpi$StoreEntry = (BcKeyStoreSpi$StoreEntry)this.table.get(string);
        if (bcKeyStoreSpi$StoreEntry != null && bcKeyStoreSpi$StoreEntry.a() != 1) {
            throw new KeyStoreException("key store already has a key entry with alias " + string);
        }
        this.table.put(string, new BcKeyStoreSpi$StoreEntry(this, string, certificate));
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        this.table.put(string, new BcKeyStoreSpi$StoreEntry(this, string, byArray, certificateArray));
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (key instanceof PrivateKey && certificateArray == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        try {
            this.table.put(string, new BcKeyStoreSpi$StoreEntry(this, string, key, cArray, certificateArray));
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception.toString());
        }
    }

    public int engineSize() {
        return this.table.size();
    }

    protected void loadStore(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = dataInputStream.read();
        while (n2 > 0) {
            String string = dataInputStream.readUTF();
            Date date = new Date(dataInputStream.readLong());
            int n3 = dataInputStream.readInt();
            Certificate[] certificateArray = null;
            if (n3 != 0) {
                certificateArray = new Certificate[n3];
                for (int i2 = 0; i2 != n3; ++i2) {
                    certificateArray[i2] = this.decodeCertificate(dataInputStream);
                }
            }
            switch (n2) {
                case 1: {
                    Certificate certificate = this.decodeCertificate(dataInputStream);
                    this.table.put(string, new BcKeyStoreSpi$StoreEntry(this, string, date, 1, certificate));
                    break;
                }
                case 2: {
                    Key key = this.decodeKey(dataInputStream);
                    this.table.put(string, new BcKeyStoreSpi$StoreEntry(this, string, date, 2, key, certificateArray));
                    break;
                }
                case 3: 
                case 4: {
                    byte[] byArray = new byte[dataInputStream.readInt()];
                    dataInputStream.readFully(byArray);
                    this.table.put(string, new BcKeyStoreSpi$StoreEntry(this, string, date, n2, byArray, certificateArray));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown object type in store.");
                }
            }
            n2 = dataInputStream.read();
        }
    }

    protected void saveStore(OutputStream outputStream) throws IOException {
        Enumeration enumeration = this.table.elements();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        block5: while (enumeration.hasMoreElements()) {
            BcKeyStoreSpi$StoreEntry bcKeyStoreSpi$StoreEntry = (BcKeyStoreSpi$StoreEntry)enumeration.nextElement();
            dataOutputStream.write(bcKeyStoreSpi$StoreEntry.a());
            dataOutputStream.writeUTF(bcKeyStoreSpi$StoreEntry.a());
            dataOutputStream.writeLong(((Date)bcKeyStoreSpi$StoreEntry.a()).getTime());
            Certificate[] certificateArray = bcKeyStoreSpi$StoreEntry.a();
            if (certificateArray == null) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(certificateArray.length);
                for (int i2 = 0; i2 != certificateArray.length; ++i2) {
                    this.encodeCertificate(certificateArray[i2], dataOutputStream);
                }
            }
            switch (bcKeyStoreSpi$StoreEntry.a()) {
                case 1: {
                    this.encodeCertificate((Certificate)bcKeyStoreSpi$StoreEntry.a(), dataOutputStream);
                    continue block5;
                }
                case 2: {
                    this.encodeKey((Key)bcKeyStoreSpi$StoreEntry.a(), dataOutputStream);
                    continue block5;
                }
                case 3: 
                case 4: {
                    byte[] byArray = (byte[])bcKeyStoreSpi$StoreEntry.a();
                    dataOutputStream.writeInt(byArray.length);
                    dataOutputStream.write(byArray);
                    continue block5;
                }
            }
            throw new RuntimeException("Unknown object type in store.");
        }
        dataOutputStream.write(0);
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
        this.table.clear();
        if (inputStream == null) {
            return;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = dataInputStream.readInt();
        if (n2 != 2 && n2 != 0 && n2 != 1) {
            throw new IOException("Wrong version of key store.");
        }
        int n3 = dataInputStream.readInt();
        if (n3 <= 0) {
            throw new IOException("Invalid salt detected");
        }
        byte[] byArray = new byte[n3];
        dataInputStream.readFully(byArray);
        int n4 = dataInputStream.readInt();
        HMac hMac = new HMac(new SHA1Digest());
        if (cArray != null && cArray.length != 0) {
            byte[] byArray2 = PBEParametersGenerator.PKCS12PasswordToBytes(cArray);
            PKCS12ParametersGenerator pKCS12ParametersGenerator = new PKCS12ParametersGenerator(new SHA1Digest());
            pKCS12ParametersGenerator.init(byArray2, byArray, n4);
            CipherParameters cipherParameters = n2 != 2 ? ((PBEParametersGenerator)pKCS12ParametersGenerator).generateDerivedMacParameters(hMac.getMacSize()) : ((PBEParametersGenerator)pKCS12ParametersGenerator).generateDerivedMacParameters(hMac.getMacSize() * 8);
            Arrays.fill(byArray2, (byte)0);
            hMac.init(cipherParameters);
            MacInputStream macInputStream = new MacInputStream(dataInputStream, hMac);
            this.loadStore(macInputStream);
            byte[] byArray3 = new byte[hMac.getMacSize()];
            hMac.doFinal(byArray3, 0);
            byte[] byArray4 = new byte[hMac.getMacSize()];
            dataInputStream.readFully(byArray4);
            if (!Arrays.constantTimeAreEqual(byArray3, byArray4)) {
                this.table.clear();
                throw new IOException("KeyStore integrity check failed.");
            }
        } else {
            this.loadStore(dataInputStream);
            byte[] byArray5 = new byte[hMac.getMacSize()];
            dataInputStream.readFully(byArray5);
        }
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        byte[] byArray = new byte[20];
        int n2 = 1024 + (this.random.nextInt() & 0x3FF);
        this.random.nextBytes(byArray);
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
        dataOutputStream.writeInt(n2);
        HMac hMac = new HMac(new SHA1Digest());
        MacOutputStream macOutputStream = new MacOutputStream(hMac);
        PKCS12ParametersGenerator pKCS12ParametersGenerator = new PKCS12ParametersGenerator(new SHA1Digest());
        byte[] byArray2 = PBEParametersGenerator.PKCS12PasswordToBytes(cArray);
        pKCS12ParametersGenerator.init(byArray2, byArray, n2);
        if (this.version < 2) {
            hMac.init(((PBEParametersGenerator)pKCS12ParametersGenerator).generateDerivedMacParameters(hMac.getMacSize()));
        } else {
            hMac.init(((PBEParametersGenerator)pKCS12ParametersGenerator).generateDerivedMacParameters(hMac.getMacSize() * 8));
        }
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            byArray2[i2] = 0;
        }
        this.saveStore(new TeeOutputStream(dataOutputStream, macOutputStream));
        byte[] byArray3 = new byte[hMac.getMacSize()];
        hMac.doFinal(byArray3, 0);
        dataOutputStream.write(byArray3);
        dataOutputStream.close();
    }

    static void a(BcKeyStoreSpi bcKeyStoreSpi, Key key, DataOutputStream dataOutputStream) throws IOException {
        bcKeyStoreSpi.encodeKey(key, dataOutputStream);
    }

    static Key a(BcKeyStoreSpi bcKeyStoreSpi, DataInputStream dataInputStream) throws IOException {
        return bcKeyStoreSpi.decodeKey(dataInputStream);
    }
}

