/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.DESParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.KeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithIV;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.util.PBE$Util;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

public class DES$DESPBEKeyFactory
extends BaseSecretKeyFactory {
    private boolean forCipher;
    private int scheme;
    private int digest;
    private int keySize;
    private int ivSize;

    public DES$DESPBEKeyFactory(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, int n2, int n3, int n4, int n5) {
        super(string, aSN1ObjectIdentifier);
        this.forCipher = bl2;
        this.scheme = n2;
        this.digest = n3;
        this.keySize = n4;
        this.ivSize = n5;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PBEKeySpec) {
            PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
            if (pBEKeySpec.getSalt() == null) {
                return new BCPBEKey(this.algName, this.algOid, this.scheme, this.digest, this.keySize, this.ivSize, pBEKeySpec, null);
            }
            CipherParameters cipherParameters = this.forCipher ? PBE$Util.makePBEParameters(pBEKeySpec, this.scheme, this.digest, this.keySize, this.ivSize) : PBE$Util.makePBEMacParameters(pBEKeySpec, this.scheme, this.digest, this.keySize);
            KeyParameter keyParameter = cipherParameters instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)cipherParameters).getParameters() : (KeyParameter)cipherParameters;
            DESParameters.setOddParity(keyParameter.getKey());
            return new BCPBEKey(this.algName, this.algOid, this.scheme, this.digest, this.keySize, this.ivSize, pBEKeySpec, cipherParameters);
        }
        throw new InvalidKeySpecException("Invalid KeySpec");
    }
}

