/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.PBEPBKDF2;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;

public class PBEPBKDF2$AlgParams
extends BaseAlgorithmParameters {
    PBKDF2Params a;

    protected byte[] engineGetEncoded() {
        try {
            return this.a.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Oooops! " + iOException.toString());
        }
    }

    protected byte[] engineGetEncoded(String string) {
        if (this.isASN1FormatString(string)) {
            return this.engineGetEncoded();
        }
        return null;
    }

    protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz == (PBEPBKDF2.a == null ? (PBEPBKDF2.a = PBEPBKDF2.a("javax.crypto.spec.PBEParameterSpec")) : PBEPBKDF2.a)) {
            return new PBEParameterSpec(this.a.getSalt(), this.a.getIterationCount().intValue());
        }
        throw new InvalidParameterSpecException("unknown parameter spec passed to PBKDF2 PBE parameters object.");
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PBKDF2 PBE parameters algorithm parameters object");
        }
        PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
        this.a = new PBKDF2Params(pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
    }

    protected void engineInit(byte[] byArray) throws IOException {
        this.a = PBKDF2Params.getInstance(ASN1Primitive.fromByteArray(byArray));
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (this.isASN1FormatString(string)) {
            this.engineInit(byArray);
            return;
        }
        throw new IOException("Unknown parameters format in PBKDF2 parameters object");
    }

    protected String engineToString() {
        return "PBKDF2 Parameters";
    }
}

