/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.PBEPKCS12;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;

public class PBEPKCS12$AlgParams
extends BaseAlgorithmParameters {
    PKCS12PBEParams a;

    protected byte[] engineGetEncoded() {
        try {
            return this.a.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Oooops! " + iOException.toString());
        }
    }

    protected byte[] engineGetEncoded(String string) {
        if (this.isASN1FormatString(string)) {
            return this.engineGetEncoded();
        }
        return null;
    }

    protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz == (PBEPKCS12.a == null ? (PBEPKCS12.a = PBEPKCS12.a("javax.crypto.spec.PBEParameterSpec")) : PBEPKCS12.a)) {
            return new PBEParameterSpec(this.a.getIV(), this.a.getIterations().intValue());
        }
        throw new InvalidParameterSpecException("unknown parameter spec passed to PKCS12 PBE parameters object.");
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PKCS12 PBE parameters algorithm parameters object");
        }
        PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
        this.a = new PKCS12PBEParams(pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
    }

    protected void engineInit(byte[] byArray) throws IOException {
        this.a = PKCS12PBEParams.getInstance(ASN1Primitive.fromByteArray(byArray));
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (this.isASN1FormatString(string)) {
            this.engineInit(byArray);
            return;
        }
        throw new IOException("Unknown parameters format in PKCS12 PBE parameters object");
    }

    protected String engineToString() {
        return "PKCS12 PBE Parameters";
    }
}

