/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jce.provider;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Encodable;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERInteger;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.oiw.ElGamalParameter;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.zeroturnaround.bundled.org.bouncycastle.jce.interfaces.ElGamalPublicKey;
import com.zeroturnaround.bundled.org.bouncycastle.jce.spec.ElGamalParameterSpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class JCEElGamalPublicKey
implements ElGamalPublicKey,
DHPublicKey {
    static final long serialVersionUID = 8712728417091216948L;
    private BigInteger y;
    private ElGamalParameterSpec elSpec;

    public String getAlgorithm() {
        return "ElGamal";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, (ASN1Encodable)new ElGamalParameter(this.elSpec.getP(), this.elSpec.getG())), new DERInteger(this.y));
    }

    public ElGamalParameterSpec getParameters() {
        return this.elSpec;
    }

    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.elSpec.getP(), this.elSpec.getG());
    }

    public BigInteger getY() {
        return this.y;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.y = (BigInteger)objectInputStream.readObject();
        this.elSpec = new ElGamalParameterSpec((BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getY());
        objectOutputStream.writeObject(this.elSpec.getP());
        objectOutputStream.writeObject(this.elSpec.getG());
    }
}

