/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jce.provider;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.BlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.DataLengthException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.StreamBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.StreamCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.KeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithIV;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.util.PBE;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.symmetric.util.PBE$Util;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JCEStreamCipher
extends CipherSpi
implements PBE {
    private Class[] availableSpecs = new Class[]{a == null ? (a = JCEStreamCipher.a("javax.crypto.spec.RC2ParameterSpec")) : a, b == null ? (b = JCEStreamCipher.a("javax.crypto.spec.RC5ParameterSpec")) : b, c == null ? (c = JCEStreamCipher.a("javax.crypto.spec.IvParameterSpec")) : c, d == null ? (d = JCEStreamCipher.a("javax.crypto.spec.PBEParameterSpec")) : d};
    private StreamCipher cipher;
    private ParametersWithIV ivParam;
    private int ivLength = 0;
    private PBEParameterSpec pbeSpec = null;
    private String pbeAlgorithm = null;
    private AlgorithmParameters engineParams;
    static Class a;
    static Class b;
    static Class c;
    static Class d;

    protected JCEStreamCipher(StreamCipher streamCipher, int n2) {
        this.cipher = streamCipher;
        this.ivLength = n2;
    }

    protected JCEStreamCipher(BlockCipher blockCipher, int n2) {
        this.ivLength = n2;
        this.cipher = new StreamBlockCipher(blockCipher);
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected byte[] engineGetIV() {
        return this.ivParam != null ? this.ivParam.getIV() : null;
    }

    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    protected int engineGetOutputSize(int n2) {
        return n2;
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.pbeSpec != null) {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.pbeAlgorithm, "BC");
                algorithmParameters.init(this.pbeSpec);
                return algorithmParameters;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.engineParams;
    }

    protected void engineSetMode(String string) {
        if (!string.equalsIgnoreCase("ECB")) {
            throw new IllegalArgumentException("can't support mode " + string);
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!string.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException("Padding " + string + " unknown.");
        }
    }

    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters cipherParameters;
        Serializable serializable;
        this.pbeSpec = null;
        this.pbeAlgorithm = null;
        this.engineParams = null;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key for algorithm " + key.getAlgorithm() + " not suitable for symmetric enryption.");
        }
        if (key instanceof BCPBEKey) {
            serializable = (BCPBEKey)key;
            this.pbeAlgorithm = ((BCPBEKey)serializable).getOID() != null ? ((BCPBEKey)serializable).getOID().getId() : ((BCPBEKey)serializable).getAlgorithm();
            if (((BCPBEKey)serializable).getParam() != null) {
                cipherParameters = ((BCPBEKey)serializable).getParam();
                this.pbeSpec = new PBEParameterSpec(((BCPBEKey)serializable).getSalt(), ((BCPBEKey)serializable).getIterationCount());
            } else if (algorithmParameterSpec instanceof PBEParameterSpec) {
                cipherParameters = PBE$Util.makePBEParameters((BCPBEKey)serializable, algorithmParameterSpec, this.cipher.getAlgorithmName());
                this.pbeSpec = (PBEParameterSpec)algorithmParameterSpec;
            } else {
                throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
            }
            if (((BCPBEKey)serializable).getIvSize() != 0) {
                this.ivParam = (ParametersWithIV)cipherParameters;
            }
        } else if (algorithmParameterSpec == null) {
            cipherParameters = new KeyParameter(key.getEncoded());
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            cipherParameters = new ParametersWithIV(new KeyParameter(key.getEncoded()), ((IvParameterSpec)algorithmParameterSpec).getIV());
            this.ivParam = (ParametersWithIV)cipherParameters;
        } else {
            throw new IllegalArgumentException("unknown parameter type.");
        }
        if (this.ivLength != 0 && !(cipherParameters instanceof ParametersWithIV)) {
            serializable = secureRandom;
            if (serializable == null) {
                serializable = new SecureRandom();
            }
            if (n2 == 1 || n2 == 3) {
                byte[] byArray = new byte[this.ivLength];
                ((SecureRandom)serializable).nextBytes(byArray);
                cipherParameters = new ParametersWithIV(cipherParameters, byArray);
                this.ivParam = (ParametersWithIV)cipherParameters;
            } else {
                throw new InvalidAlgorithmParameterException("no IV set when one expected");
            }
        }
        switch (n2) {
            case 1: 
            case 3: {
                this.cipher.init(true, cipherParameters);
                break;
            }
            case 2: 
            case 4: {
                this.cipher.init(false, cipherParameters);
                break;
            }
            default: {
                System.out.println("eeek!");
            }
        }
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            for (int i2 = 0; i2 != this.availableSpecs.length; ++i2) {
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(this.availableSpecs[i2]);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineInit(n2, key, algorithmParameterSpec, secureRandom);
        this.engineParams = algorithmParameters;
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        this.cipher.processBytes(byArray, n2, n3, byArray2, 0);
        return byArray2;
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        try {
            this.cipher.processBytes(byArray, n2, n3, byArray2, n4);
            return n3;
        }
        catch (DataLengthException dataLengthException) {
            throw new ShortBufferException(dataLengthException.getMessage());
        }
    }

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws BadPaddingException, IllegalBlockSizeException {
        if (n3 != 0) {
            byte[] byArray2 = this.engineUpdate(byArray, n2, n3);
            this.cipher.reset();
            return byArray2;
        }
        this.cipher.reset();
        return new byte[0];
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws BadPaddingException {
        if (n3 != 0) {
            this.cipher.processBytes(byArray, n2, n3, byArray2, n4);
        }
        this.cipher.reset();
        return n3;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IllegalBlockSizeException(badPaddingException.getMessage());
        }
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException {
        byte[] byArray2;
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        if (n2 == 3) {
            return new SecretKeySpec(byArray2, string);
        }
        if (string.equals("") && n2 == 2) {
            try {
                PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(byArray2);
                PrivateKey privateKey = BouncyCastleProvider.getPrivateKey(privateKeyInfo);
                if (privateKey != null) {
                    return privateKey;
                }
                throw new InvalidKeyException("algorithm " + privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm() + " not supported");
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Invalid key encoding.");
            }
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string, "BC");
            if (n2 == 1) {
                return keyFactory.generatePublic(new X509EncodedKeySpec(byArray2));
            }
            if (n2 == 2) {
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InvalidKeyException("Unknown key type " + noSuchProviderException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("Unknown key type " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Unknown key type " + invalidKeySpecException.getMessage());
        }
        throw new InvalidKeyException("Unknown key type " + n2);
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

