/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.math.ec;

import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECConstants;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECCurve;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECFieldElement;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECFieldElement$F2m;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint$F2m;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.Tnaf;
import java.math.BigInteger;
import java.util.Random;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ECCurve$F2m
extends ECCurve {
    private int m;
    private int k1;
    private int k2;
    private int k3;
    private BigInteger n;
    private BigInteger h;
    private ECPoint$F2m infinity;
    private byte mu = 0;
    private BigInteger[] si = null;

    public ECCurve$F2m(int n2, int n3, BigInteger bigInteger, BigInteger bigInteger2) {
        this(n2, n3, 0, 0, bigInteger, bigInteger2, null, null);
    }

    public ECCurve$F2m(int n2, int n3, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(n2, n3, 0, 0, bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public ECCurve$F2m(int n2, int n3, int n4, int n5, BigInteger bigInteger, BigInteger bigInteger2) {
        this(n2, n3, n4, n5, bigInteger, bigInteger2, null, null);
    }

    public ECCurve$F2m(int n2, int n3, int n4, int n5, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.m = n2;
        this.k1 = n3;
        this.k2 = n4;
        this.k3 = n5;
        this.n = bigInteger3;
        this.h = bigInteger4;
        if (n3 == 0) {
            throw new IllegalArgumentException("k1 must be > 0");
        }
        if (n4 == 0) {
            if (n5 != 0) {
                throw new IllegalArgumentException("k3 must be 0 if k2 == 0");
            }
        } else {
            if (n4 <= n3) {
                throw new IllegalArgumentException("k2 must be > k1");
            }
            if (n5 <= n4) {
                throw new IllegalArgumentException("k3 must be > k2");
            }
        }
        this.a = this.fromBigInteger(bigInteger);
        this.b = this.fromBigInteger(bigInteger2);
        this.infinity = new ECPoint$F2m(this, null, null);
    }

    public int getFieldSize() {
        return this.m;
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new ECFieldElement$F2m(this.m, this.k1, this.k2, this.k3, bigInteger);
    }

    public ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2, boolean bl2) {
        return new ECPoint$F2m(this, this.fromBigInteger(bigInteger), this.fromBigInteger(bigInteger2), bl2);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return this.n != null && this.h != null && (this.a.toBigInteger().equals(ECConstants.ZERO) || this.a.toBigInteger().equals(ECConstants.ONE)) && this.b.toBigInteger().equals(ECConstants.ONE);
    }

    synchronized byte a() {
        if (this.mu == 0) {
            this.mu = Tnaf.getMu(this);
        }
        return this.mu;
    }

    synchronized BigInteger[] a() {
        if (this.si == null) {
            this.si = Tnaf.getSi(this);
        }
        return this.si;
    }

    protected ECPoint decompressPoint(int n2, BigInteger bigInteger) {
        ECFieldElement eCFieldElement = this.fromBigInteger(bigInteger);
        ECFieldElement eCFieldElement2 = null;
        if (eCFieldElement.toBigInteger().equals(ECConstants.ZERO)) {
            eCFieldElement2 = (ECFieldElement$F2m)this.b;
            for (int i2 = 0; i2 < this.m - 1; ++i2) {
                eCFieldElement2 = ((ECFieldElement)eCFieldElement2).square();
            }
        } else {
            int n3;
            ECFieldElement eCFieldElement3 = eCFieldElement.add(this.a).add(this.b.multiply(eCFieldElement.square().invert()));
            ECFieldElement eCFieldElement4 = this.solveQuadradicEquation(eCFieldElement3);
            if (eCFieldElement4 == null) {
                throw new IllegalArgumentException("Invalid point compression");
            }
            int n4 = n3 = eCFieldElement4.toBigInteger().testBit(0) ? 1 : 0;
            if (n3 != n2) {
                eCFieldElement4 = eCFieldElement4.add(this.fromBigInteger(ECConstants.ONE));
            }
            eCFieldElement2 = eCFieldElement.multiply(eCFieldElement4);
        }
        return new ECPoint$F2m(this, eCFieldElement, eCFieldElement2, true);
    }

    private ECFieldElement solveQuadradicEquation(ECFieldElement eCFieldElement) {
        ECFieldElement$F2m eCFieldElement$F2m = new ECFieldElement$F2m(this.m, this.k1, this.k2, this.k3, ECConstants.ZERO);
        if (eCFieldElement.toBigInteger().equals(ECConstants.ZERO)) {
            return eCFieldElement$F2m;
        }
        ECFieldElement eCFieldElement2 = null;
        ECFieldElement eCFieldElement3 = eCFieldElement$F2m;
        Random random = new Random();
        do {
            ECFieldElement$F2m eCFieldElement$F2m2 = new ECFieldElement$F2m(this.m, this.k1, this.k2, this.k3, new BigInteger(this.m, random));
            eCFieldElement2 = eCFieldElement$F2m;
            ECFieldElement eCFieldElement4 = eCFieldElement;
            for (int i2 = 1; i2 <= this.m - 1; ++i2) {
                ECFieldElement eCFieldElement5 = eCFieldElement4.square();
                eCFieldElement2 = ((ECFieldElement)eCFieldElement2).square().add(eCFieldElement5.multiply(eCFieldElement$F2m2));
                eCFieldElement4 = eCFieldElement5.add(eCFieldElement);
            }
            if (eCFieldElement4.toBigInteger().equals(ECConstants.ZERO)) continue;
            return null;
        } while ((eCFieldElement3 = ((ECFieldElement)eCFieldElement2).square().add(eCFieldElement2)).toBigInteger().equals(ECConstants.ZERO));
        return eCFieldElement2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECCurve$F2m)) {
            return false;
        }
        ECCurve$F2m eCCurve$F2m = (ECCurve$F2m)object;
        return this.m == eCCurve$F2m.m && this.k1 == eCCurve$F2m.k1 && this.k2 == eCCurve$F2m.k2 && this.k3 == eCCurve$F2m.k3 && this.a.equals(eCCurve$F2m.a) && this.b.equals(eCCurve$F2m.b);
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode() ^ this.m ^ this.k1 ^ this.k2 ^ this.k3;
    }

    public int getM() {
        return this.m;
    }

    public boolean isTrinomial() {
        return this.k2 == 0 && this.k3 == 0;
    }

    public int getK1() {
        return this.k1;
    }

    public int getK2() {
        return this.k2;
    }

    public int getK3() {
        return this.k3;
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getH() {
        return this.h;
    }
}

