/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.math.ec;

import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECFieldElement;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.IntArray;
import java.math.BigInteger;

public class ECFieldElement$F2m
extends ECFieldElement {
    public static final int GNB = 1;
    public static final int TPB = 2;
    public static final int PPB = 3;
    private int representation;
    private int m;
    private int k1;
    private int k2;
    private int k3;
    private IntArray x;
    private int t;

    public ECFieldElement$F2m(int n2, int n3, int n4, int n5, BigInteger bigInteger) {
        this.t = n2 + 31 >> 5;
        this.x = new IntArray(bigInteger, this.t);
        if (n4 == 0 && n5 == 0) {
            this.representation = 2;
        } else {
            if (n4 >= n5) {
                throw new IllegalArgumentException("k2 must be smaller than k3");
            }
            if (n4 <= 0) {
                throw new IllegalArgumentException("k2 must be larger than 0");
            }
            this.representation = 3;
        }
        if (bigInteger.signum() < 0) {
            throw new IllegalArgumentException("x value cannot be negative");
        }
        this.m = n2;
        this.k1 = n3;
        this.k2 = n4;
        this.k3 = n5;
    }

    public ECFieldElement$F2m(int n2, int n3, BigInteger bigInteger) {
        this(n2, n3, 0, 0, bigInteger);
    }

    private ECFieldElement$F2m(int n2, int n3, int n4, int n5, IntArray intArray) {
        this.t = n2 + 31 >> 5;
        this.x = intArray;
        this.m = n2;
        this.k1 = n3;
        this.k2 = n4;
        this.k3 = n5;
        this.representation = n4 == 0 && n5 == 0 ? 2 : 3;
    }

    public BigInteger toBigInteger() {
        return this.x.toBigInteger();
    }

    public String getFieldName() {
        return "F2m";
    }

    public int getFieldSize() {
        return this.m;
    }

    public static void checkFieldElements(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        if (!(eCFieldElement instanceof ECFieldElement$F2m) || !(eCFieldElement2 instanceof ECFieldElement$F2m)) {
            throw new IllegalArgumentException("Field elements are not both instances of ECFieldElement.F2m");
        }
        ECFieldElement$F2m eCFieldElement$F2m = (ECFieldElement$F2m)eCFieldElement;
        ECFieldElement$F2m eCFieldElement$F2m2 = (ECFieldElement$F2m)eCFieldElement2;
        if (eCFieldElement$F2m.m != eCFieldElement$F2m2.m || eCFieldElement$F2m.k1 != eCFieldElement$F2m2.k1 || eCFieldElement$F2m.k2 != eCFieldElement$F2m2.k2 || eCFieldElement$F2m.k3 != eCFieldElement$F2m2.k3) {
            throw new IllegalArgumentException("Field elements are not elements of the same field F2m");
        }
        if (eCFieldElement$F2m.representation != eCFieldElement$F2m2.representation) {
            throw new IllegalArgumentException("One of the field elements are not elements has incorrect representation");
        }
    }

    public ECFieldElement add(ECFieldElement eCFieldElement) {
        IntArray intArray = (IntArray)this.x.clone();
        ECFieldElement$F2m eCFieldElement$F2m = (ECFieldElement$F2m)eCFieldElement;
        intArray.addShifted(eCFieldElement$F2m.x, 0);
        return new ECFieldElement$F2m(this.m, this.k1, this.k2, this.k3, intArray);
    }

    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        return this.add(eCFieldElement);
    }

    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        ECFieldElement$F2m eCFieldElement$F2m = (ECFieldElement$F2m)eCFieldElement;
        IntArray intArray = this.x.multiply(eCFieldElement$F2m.x, this.m);
        intArray.reduce(this.m, new int[]{this.k1, this.k2, this.k3});
        return new ECFieldElement$F2m(this.m, this.k1, this.k2, this.k3, intArray);
    }

    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        ECFieldElement eCFieldElement2 = eCFieldElement.invert();
        return this.multiply(eCFieldElement2);
    }

    public ECFieldElement negate() {
        return this;
    }

    public ECFieldElement square() {
        IntArray intArray = this.x.square(this.m);
        intArray.reduce(this.m, new int[]{this.k1, this.k2, this.k3});
        return new ECFieldElement$F2m(this.m, this.k1, this.k2, this.k3, intArray);
    }

    public ECFieldElement invert() {
        IntArray intArray = (IntArray)this.x.clone();
        IntArray intArray2 = new IntArray(this.t);
        intArray2.setBit(this.m);
        intArray2.setBit(0);
        intArray2.setBit(this.k1);
        if (this.representation == 3) {
            intArray2.setBit(this.k2);
            intArray2.setBit(this.k3);
        }
        IntArray intArray3 = new IntArray(this.t);
        intArray3.setBit(0);
        IntArray intArray4 = new IntArray(this.t);
        while (!intArray.isZero()) {
            int n2 = intArray.bitLength() - intArray2.bitLength();
            if (n2 < 0) {
                IntArray intArray5 = intArray;
                intArray = intArray2;
                intArray2 = intArray5;
                IntArray intArray6 = intArray3;
                intArray3 = intArray4;
                intArray4 = intArray6;
                n2 = -n2;
            }
            int n3 = n2 >> 5;
            int n4 = n2 & 0x1F;
            IntArray intArray7 = intArray2.shiftLeft(n4);
            intArray.addShifted(intArray7, n3);
            IntArray intArray8 = intArray4.shiftLeft(n4);
            intArray3.addShifted(intArray8, n3);
        }
        return new ECFieldElement$F2m(this.m, this.k1, this.k2, this.k3, intArray4);
    }

    public ECFieldElement sqrt() {
        throw new RuntimeException("Not implemented");
    }

    public int getRepresentation() {
        return this.representation;
    }

    public int getM() {
        return this.m;
    }

    public int getK1() {
        return this.k1;
    }

    public int getK2() {
        return this.k2;
    }

    public int getK3() {
        return this.k3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECFieldElement$F2m)) {
            return false;
        }
        ECFieldElement$F2m eCFieldElement$F2m = (ECFieldElement$F2m)object;
        return this.m == eCFieldElement$F2m.m && this.k1 == eCFieldElement$F2m.k1 && this.k2 == eCFieldElement$F2m.k2 && this.k3 == eCFieldElement$F2m.k3 && this.representation == eCFieldElement$F2m.representation && this.x.equals(eCFieldElement$F2m.x);
    }

    public int hashCode() {
        return this.x.hashCode() ^ this.m ^ this.k1 ^ this.k2 ^ this.k3;
    }
}

