/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.math.ec;

import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECConstants;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECCurve;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECCurve$F2m;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECFieldElement;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECFieldElement$F2m;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.WNafMultiplier;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.WTauNafMultiplier;

public class ECPoint$F2m
extends ECPoint {
    public ECPoint$F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this(eCCurve, eCFieldElement, eCFieldElement2, false);
    }

    public ECPoint$F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        super(eCCurve, eCFieldElement, eCFieldElement2);
        if (eCFieldElement != null && eCFieldElement2 == null || eCFieldElement == null && eCFieldElement2 != null) {
            throw new IllegalArgumentException("Exactly one of the field elements is null");
        }
        if (eCFieldElement != null) {
            ECFieldElement$F2m.checkFieldElements(this.a, this.b);
            if (eCCurve != null) {
                ECFieldElement$F2m.checkFieldElements(this.a, this.a.getA());
            }
        }
        this.withCompression = bl2;
    }

    public byte[] getEncoded(boolean bl2) {
        byte[] byArray;
        if (this.isInfinity()) {
            return new byte[1];
        }
        int n2 = ECPoint.a().getByteLength(this.a);
        byte[] byArray2 = ECPoint.a().integerToBytes(this.getX().toBigInteger(), n2);
        if (bl2) {
            byArray = new byte[n2 + 1];
            byArray[0] = 2;
            if (!this.getX().toBigInteger().equals(ECConstants.ZERO) && this.getY().multiply(this.getX().invert()).toBigInteger().testBit(0)) {
                byArray[0] = 3;
            }
            System.arraycopy(byArray2, 0, byArray, 1, n2);
        } else {
            byte[] byArray3 = ECPoint.a().integerToBytes(this.getY().toBigInteger(), n2);
            byArray = new byte[n2 + n2 + 1];
            byArray[0] = 4;
            System.arraycopy(byArray2, 0, byArray, 1, n2);
            System.arraycopy(byArray3, 0, byArray, n2 + 1, n2);
        }
        return byArray;
    }

    private static void checkPoints(ECPoint eCPoint, ECPoint eCPoint2) {
        if (!eCPoint.a.equals(eCPoint2.a)) {
            throw new IllegalArgumentException("Only points on the same curve can be added or subtracted");
        }
    }

    public ECPoint add(ECPoint eCPoint) {
        ECPoint$F2m.checkPoints(this, eCPoint);
        return this.addSimple((ECPoint$F2m)eCPoint);
    }

    public ECPoint$F2m addSimple(ECPoint$F2m eCPoint$F2m) {
        ECPoint$F2m eCPoint$F2m2 = eCPoint$F2m;
        if (this.isInfinity()) {
            return eCPoint$F2m2;
        }
        if (eCPoint$F2m2.isInfinity()) {
            return this;
        }
        ECFieldElement$F2m eCFieldElement$F2m = (ECFieldElement$F2m)eCPoint$F2m2.getX();
        ECFieldElement$F2m eCFieldElement$F2m2 = (ECFieldElement$F2m)eCPoint$F2m2.getY();
        if (this.a.equals(eCFieldElement$F2m)) {
            if (this.b.equals(eCFieldElement$F2m2)) {
                return (ECPoint$F2m)this.twice();
            }
            return (ECPoint$F2m)this.a.getInfinity();
        }
        ECFieldElement$F2m eCFieldElement$F2m3 = (ECFieldElement$F2m)this.b.add(eCFieldElement$F2m2).divide(this.a.add(eCFieldElement$F2m));
        ECFieldElement$F2m eCFieldElement$F2m4 = (ECFieldElement$F2m)eCFieldElement$F2m3.square().add(eCFieldElement$F2m3).add(this.a).add(eCFieldElement$F2m).add(this.a.getA());
        ECFieldElement$F2m eCFieldElement$F2m5 = (ECFieldElement$F2m)eCFieldElement$F2m3.multiply(this.a.add(eCFieldElement$F2m4)).add(eCFieldElement$F2m4).add(this.b);
        return new ECPoint$F2m(this.a, eCFieldElement$F2m4, eCFieldElement$F2m5, this.withCompression);
    }

    public ECPoint subtract(ECPoint eCPoint) {
        ECPoint$F2m.checkPoints(this, eCPoint);
        return this.subtractSimple((ECPoint$F2m)eCPoint);
    }

    public ECPoint$F2m subtractSimple(ECPoint$F2m eCPoint$F2m) {
        if (eCPoint$F2m.isInfinity()) {
            return this;
        }
        return this.addSimple((ECPoint$F2m)eCPoint$F2m.negate());
    }

    public ECPoint twice() {
        if (this.isInfinity()) {
            return this;
        }
        if (this.a.toBigInteger().signum() == 0) {
            return this.a.getInfinity();
        }
        ECFieldElement$F2m eCFieldElement$F2m = (ECFieldElement$F2m)this.a.add(this.b.divide(this.a));
        ECFieldElement$F2m eCFieldElement$F2m2 = (ECFieldElement$F2m)eCFieldElement$F2m.square().add(eCFieldElement$F2m).add(this.a.getA());
        ECFieldElement eCFieldElement = this.a.fromBigInteger(ECConstants.ONE);
        ECFieldElement$F2m eCFieldElement$F2m3 = (ECFieldElement$F2m)this.a.square().add(eCFieldElement$F2m2.multiply(eCFieldElement$F2m.add(eCFieldElement)));
        return new ECPoint$F2m(this.a, eCFieldElement$F2m2, eCFieldElement$F2m3, this.withCompression);
    }

    public ECPoint negate() {
        return new ECPoint$F2m(this.a, this.getX(), this.getY().add(this.getX()), this.withCompression);
    }

    synchronized void a() {
        if (this.multiplier == null) {
            this.multiplier = ((ECCurve$F2m)this.a).isKoblitz() ? new WTauNafMultiplier() : new WNafMultiplier();
        }
    }
}

