/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.math.ec;

import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECCurve;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECFieldElement;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.WNafMultiplier;
import java.math.BigInteger;

public class ECPoint$Fp
extends ECPoint {
    public ECPoint$Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this(eCCurve, eCFieldElement, eCFieldElement2, false);
    }

    public ECPoint$Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        super(eCCurve, eCFieldElement, eCFieldElement2);
        if (eCFieldElement != null && eCFieldElement2 == null || eCFieldElement == null && eCFieldElement2 != null) {
            throw new IllegalArgumentException("Exactly one of the field elements is null");
        }
        this.withCompression = bl2;
    }

    public byte[] getEncoded(boolean bl2) {
        if (this.isInfinity()) {
            return new byte[1];
        }
        int n2 = ECPoint.a().getByteLength(this.a);
        if (bl2) {
            int n3 = this.getY().toBigInteger().testBit(0) ? 3 : 2;
            byte[] byArray = ECPoint.a().integerToBytes(this.getX().toBigInteger(), n2);
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = n3;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            return byArray2;
        }
        byte[] byArray = ECPoint.a().integerToBytes(this.getX().toBigInteger(), n2);
        byte[] byArray3 = ECPoint.a().integerToBytes(this.getY().toBigInteger(), n2);
        byte[] byArray4 = new byte[byArray.length + byArray3.length + 1];
        byArray4[0] = 4;
        System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + 1, byArray3.length);
        return byArray4;
    }

    public ECPoint add(ECPoint eCPoint) {
        if (this.isInfinity()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this;
        }
        if (this.a.equals(eCPoint.a)) {
            if (this.b.equals(eCPoint.b)) {
                return this.twice();
            }
            return this.a.getInfinity();
        }
        ECFieldElement eCFieldElement = eCPoint.b.subtract(this.b).divide(eCPoint.a.subtract(this.a));
        ECFieldElement eCFieldElement2 = eCFieldElement.square().subtract(this.a).subtract(eCPoint.a);
        ECFieldElement eCFieldElement3 = eCFieldElement.multiply(this.a.subtract(eCFieldElement2)).subtract(this.b);
        return new ECPoint$Fp(this.a, eCFieldElement2, eCFieldElement3, this.withCompression);
    }

    public ECPoint twice() {
        if (this.isInfinity()) {
            return this;
        }
        if (this.b.toBigInteger().signum() == 0) {
            return this.a.getInfinity();
        }
        ECFieldElement eCFieldElement = this.a.fromBigInteger(BigInteger.valueOf(2L));
        ECFieldElement eCFieldElement2 = this.a.fromBigInteger(BigInteger.valueOf(3L));
        ECFieldElement eCFieldElement3 = this.a.square().multiply(eCFieldElement2).add(this.a.a).divide(this.b.multiply(eCFieldElement));
        ECFieldElement eCFieldElement4 = eCFieldElement3.square().subtract(this.a.multiply(eCFieldElement));
        ECFieldElement eCFieldElement5 = eCFieldElement3.multiply(this.a.subtract(eCFieldElement4)).subtract(this.b);
        return new ECPoint$Fp(this.a, eCFieldElement4, eCFieldElement5, this.withCompression);
    }

    public ECPoint subtract(ECPoint eCPoint) {
        if (eCPoint.isInfinity()) {
            return this;
        }
        return this.add(eCPoint.negate());
    }

    public ECPoint negate() {
        return new ECPoint$Fp(this.a, this.a, this.b.negate(), this.withCompression);
    }

    synchronized void a() {
        if (this.multiplier == null) {
            this.multiplier = new WNafMultiplier();
        }
    }
}

