/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.math.ec;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.x9.X9IntegerConverter;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECCurve;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECFieldElement;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECMultiplier;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.FpNafMultiplier;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.PreCompInfo;
import java.math.BigInteger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class ECPoint {
    ECCurve a;
    ECFieldElement a;
    ECFieldElement b;
    protected boolean withCompression;
    protected ECMultiplier multiplier = null;
    protected PreCompInfo preCompInfo = null;
    private static X9IntegerConverter converter = new X9IntegerConverter();

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this.a = eCCurve;
        this.a = eCFieldElement;
        this.b = eCFieldElement2;
    }

    public ECCurve getCurve() {
        return this.a;
    }

    public ECFieldElement getX() {
        return this.a;
    }

    public ECFieldElement getY() {
        return this.b;
    }

    public boolean isInfinity() {
        return this.a == null && this.b == null;
    }

    public boolean isCompressed() {
        return this.withCompression;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPoint)) {
            return false;
        }
        ECPoint eCPoint = (ECPoint)object;
        if (this.isInfinity()) {
            return eCPoint.isInfinity();
        }
        return this.a.equals(eCPoint.a) && this.b.equals(eCPoint.b);
    }

    public int hashCode() {
        if (this.isInfinity()) {
            return 0;
        }
        return this.a.hashCode() ^ this.b.hashCode();
    }

    void a(PreCompInfo preCompInfo) {
        this.preCompInfo = preCompInfo;
    }

    public byte[] getEncoded() {
        return this.getEncoded(this.withCompression);
    }

    public abstract byte[] getEncoded(boolean var1);

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint negate();

    public abstract ECPoint twice();

    synchronized void a() {
        if (this.multiplier == null) {
            this.multiplier = new FpNafMultiplier();
        }
    }

    public ECPoint multiply(BigInteger bigInteger) {
        if (bigInteger.signum() < 0) {
            throw new IllegalArgumentException("The multiplicator cannot be negative");
        }
        if (this.isInfinity()) {
            return this;
        }
        if (bigInteger.signum() == 0) {
            return this.a.getInfinity();
        }
        this.a();
        return this.multiplier.multiply(this, bigInteger, this.preCompInfo);
    }

    static X9IntegerConverter a() {
        return converter;
    }
}

