/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.ocsp;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Encodable;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1OutputStream;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp.ResponseData;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp.SingleResponse;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.X509Extensions;
import com.zeroturnaround.bundled.org.bouncycastle.ocsp.OCSPException;
import com.zeroturnaround.bundled.org.bouncycastle.ocsp.OCSPUtil;
import com.zeroturnaround.bundled.org.bouncycastle.ocsp.RespData;
import com.zeroturnaround.bundled.org.bouncycastle.ocsp.RespID;
import com.zeroturnaround.bundled.org.bouncycastle.ocsp.SingleResp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BasicOCSPResp
implements X509Extension {
    BasicOCSPResponse a;
    ResponseData a;
    X509Certificate[] a = null;

    public BasicOCSPResp(BasicOCSPResponse basicOCSPResponse) {
        this.a = basicOCSPResponse;
        this.a = basicOCSPResponse.getTbsResponseData();
    }

    public byte[] getTBSResponseData() throws OCSPException {
        try {
            return this.a.getTbsResponseData().getEncoded();
        }
        catch (IOException iOException) {
            throw new OCSPException("problem encoding tbsResponseData", iOException);
        }
    }

    public int getVersion() {
        return this.a.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.a.getResponderID());
    }

    public Date getProducedAt() {
        try {
            return this.a.getProducedAt().getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("ParseException:" + parseException.getMessage());
        }
    }

    public SingleResp[] getResponses() {
        ASN1Sequence aSN1Sequence = this.a.getResponses();
        SingleResp[] singleRespArray = new SingleResp[aSN1Sequence.size()];
        for (int i2 = 0; i2 != singleRespArray.length; ++i2) {
            singleRespArray[i2] = new SingleResp(SingleResponse.getInstance(aSN1Sequence.getObjectAt(i2)));
        }
        return singleRespArray;
    }

    public X509Extensions getResponseExtensions() {
        return X509Extensions.getInstance(this.a.getResponseExtensions());
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        return set != null && !set.isEmpty();
    }

    private Set getExtensionOIDs(boolean bl2) {
        HashSet<String> hashSet = new HashSet<String>();
        X509Extensions x509Extensions = this.getResponseExtensions();
        if (x509Extensions != null) {
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (bl2 != x509Extension.isCritical()) continue;
                hashSet.add(dERObjectIdentifier.getId());
            }
        }
        return hashSet;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String string) {
        com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.X509Extension x509Extension;
        X509Extensions x509Extensions = this.getResponseExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string))) != null) {
            try {
                return x509Extension.getValue().getEncoded("DER");
            }
            catch (Exception exception) {
                throw new RuntimeException("error encoding " + exception.toString());
            }
        }
        return null;
    }

    public String getSignatureAlgName() {
        return OCSPUtil.a(this.a.getSignatureAlgorithm().getObjectId());
    }

    public String getSignatureAlgOID() {
        return this.a.getSignatureAlgorithm().getObjectId().getId();
    }

    public RespData getResponseData() {
        return new RespData(this.a.getTbsResponseData());
    }

    public byte[] getSignature() {
        return this.a.getSignature().getBytes();
    }

    private List getCertList(String string) throws OCSPException, NoSuchProviderException {
        CertificateFactory certificateFactory;
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            certificateFactory = OCSPUtil.a(string);
        }
        catch (CertificateException certificateException) {
            throw new OCSPException("can't get certificate factory.", certificateException);
        }
        ASN1Sequence aSN1Sequence = this.a.getCerts();
        if (aSN1Sequence != null) {
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                try {
                    aSN1OutputStream.writeObject((ASN1Encodable)enumeration.nextElement());
                    arrayList.add(certificateFactory.generateCertificate(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
                }
                catch (IOException iOException) {
                    throw new OCSPException("can't re-encode certificate!", iOException);
                }
                catch (CertificateException certificateException) {
                    throw new OCSPException("can't re-encode certificate!", certificateException);
                }
                byteArrayOutputStream.reset();
            }
        }
        return arrayList;
    }

    public X509Certificate[] getCerts(String string) throws OCSPException, NoSuchProviderException {
        List list = this.getCertList(string);
        return list.toArray(new X509Certificate[list.size()]);
    }

    public CertStore getCertificates(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, OCSPException {
        try {
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(this.getCertList(string2));
            return OCSPUtil.a(string, collectionCertStoreParameters, string2);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new OCSPException("can't setup the CertStore", invalidAlgorithmParameterException);
        }
    }

    public boolean verify(PublicKey publicKey, String string) throws OCSPException, NoSuchProviderException {
        try {
            Signature signature = OCSPUtil.a(this.getSignatureAlgName(), string);
            signature.initVerify(publicKey);
            signature.update(this.a.getTbsResponseData().getEncoded("DER"));
            return signature.verify(this.getSignature());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (Exception exception) {
            throw new OCSPException("exception processing sig: " + exception, exception);
        }
    }

    public byte[] getEncoded() throws IOException {
        return this.a.getEncoded();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BasicOCSPResp)) {
            return false;
        }
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)object;
        return this.a.equals(basicOCSPResp.a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }
}

