/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.ocsp;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1InputStream;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DEROctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp.ResponderID;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x500.X500Name;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.ocsp.OCSPException;
import com.zeroturnaround.bundled.org.bouncycastle.ocsp.OCSPUtil;
import java.security.MessageDigest;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;

public class RespID {
    ResponderID a;

    public RespID(ResponderID responderID) {
        this.a = responderID;
    }

    public RespID(X500Principal x500Principal) {
        this.a = new ResponderID(X500Name.getInstance(x500Principal.getEncoded()));
    }

    public RespID(PublicKey publicKey) throws OCSPException {
        try {
            MessageDigest messageDigest = OCSPUtil.a("SHA1", null);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(publicKey.getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            messageDigest.update(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            DEROctetString dEROctetString = new DEROctetString(messageDigest.digest());
            this.a = new ResponderID(dEROctetString);
        }
        catch (Exception exception) {
            throw new OCSPException("problem creating ID: " + exception, exception);
        }
    }

    public ResponderID toASN1Object() {
        return this.a;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RespID)) {
            return false;
        }
        RespID respID = (RespID)object;
        return this.a.equals(respID.a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }
}

