/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.pqc.crypto.mceliece;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.zeroturnaround.bundled.org.bouncycastle.pqc.crypto.MessageEncryptor;

public class McElieceFujisakiDigestCipher {
    private final Digest messDigest;
    private final MessageEncryptor mcElieceCCA2Cipher;
    private boolean forEncrypting;

    public McElieceFujisakiDigestCipher(MessageEncryptor messageEncryptor, Digest digest) {
        this.mcElieceCCA2Cipher = messageEncryptor;
        this.messDigest = digest;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.forEncrypting = bl2;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl2 && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Encrypting Requires Public Key.");
        }
        if (!bl2 && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Decrypting Requires Private Key.");
        }
        this.reset();
        this.mcElieceCCA2Cipher.init(bl2, cipherParameters);
    }

    public byte[] messageEncrypt() {
        if (!this.forEncrypting) {
            throw new IllegalStateException("McElieceFujisakiDigestCipher not initialised for encrypting.");
        }
        byte[] byArray = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(byArray, 0);
        byte[] byArray2 = null;
        try {
            byArray2 = this.mcElieceCCA2Cipher.messageEncrypt(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] messageDecrypt(byte[] byArray) {
        byte[] byArray2 = null;
        if (this.forEncrypting) {
            throw new IllegalStateException("McElieceFujisakiDigestCipher not initialised for decrypting.");
        }
        try {
            byArray2 = this.mcElieceCCA2Cipher.messageDecrypt(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    public void update(byte by2) {
        this.messDigest.update(by2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.messDigest.update(byArray, n2, n3);
    }

    public void reset() {
        this.messDigest.reset();
    }
}

