/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.pqc.jcajce.provider.gmss;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Encodable;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.pqc.asn1.GMSSPublicKey;
import com.zeroturnaround.bundled.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.pqc.asn1.ParSet;
import com.zeroturnaround.bundled.org.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.zeroturnaround.bundled.org.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import com.zeroturnaround.bundled.org.bouncycastle.pqc.jcajce.spec.GMSSPublicKeySpec;
import com.zeroturnaround.bundled.org.bouncycastle.util.encoders.Hex;
import java.security.PublicKey;

public class BCGMSSPublicKey
implements CipherParameters,
PublicKey {
    private static final long serialVersionUID = 1L;
    private byte[] publicKeyBytes;
    private GMSSParameters gmssParameterSet;
    private GMSSParameters gmssParams;

    public BCGMSSPublicKey(byte[] byArray, GMSSParameters gMSSParameters) {
        this.gmssParameterSet = gMSSParameters;
        this.publicKeyBytes = byArray;
    }

    protected BCGMSSPublicKey(GMSSPublicKeySpec gMSSPublicKeySpec) {
        this(gMSSPublicKeySpec.getPublicKey(), gMSSPublicKeySpec.getParameters());
    }

    public BCGMSSPublicKey(GMSSPublicKeyParameters gMSSPublicKeyParameters) {
        this(gMSSPublicKeyParameters.getPublicKey(), gMSSPublicKeyParameters.getParameters());
    }

    public String getAlgorithm() {
        return "GMSS";
    }

    public byte[] getPublicKeyBytes() {
        return this.publicKeyBytes;
    }

    public GMSSParameters getParameterSet() {
        return this.gmssParameterSet;
    }

    public String toString() {
        String string = "GMSS public key : " + new String(Hex.encode(this.publicKeyBytes)) + "\n" + "Height of Trees: \n";
        for (int i2 = 0; i2 < this.gmssParameterSet.getHeightOfTrees().length; ++i2) {
            string = string + "Layer " + i2 + " : " + this.gmssParameterSet.getHeightOfTrees()[i2] + " WinternitzParameter: " + this.gmssParameterSet.getWinternitzParameter()[i2] + " K: " + this.gmssParameterSet.getK()[i2] + "\n";
        }
        return string;
    }

    public byte[] getEncoded() {
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PQCObjectIdentifiers.gmss, (ASN1Encodable)new ParSet(this.gmssParameterSet.getNumOfLayers(), this.gmssParameterSet.getHeightOfTrees(), this.gmssParameterSet.getWinternitzParameter(), this.gmssParameterSet.getK()).toASN1Primitive()), new GMSSPublicKey(this.publicKeyBytes));
    }

    public String getFormat() {
        return "X.509";
    }
}

