/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.util;

public class IPAddress {
    public static boolean isValid(String string) {
        return IPAddress.isValidIPv4(string) || IPAddress.isValidIPv6(string);
    }

    public static boolean isValidWithNetMask(String string) {
        return IPAddress.isValidIPv4WithNetmask(string) || IPAddress.isValidIPv6WithNetmask(string);
    }

    public static boolean isValidIPv4(String string) {
        int n2;
        if (string.length() == 0) {
            return false;
        }
        int n3 = 0;
        String string2 = string + ".";
        int n4 = 0;
        while (n4 < string2.length() && (n2 = string2.indexOf(46, n4)) > n4) {
            int n5;
            if (n3 == 4) {
                return false;
            }
            try {
                n5 = Integer.parseInt(string2.substring(n4, n2));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n5 < 0 || n5 > 255) {
                return false;
            }
            n4 = n2 + 1;
            ++n3;
        }
        return n3 == 4;
    }

    public static boolean isValidIPv4WithNetmask(String string) {
        int n2 = string.indexOf("/");
        String string2 = string.substring(n2 + 1);
        return n2 > 0 && IPAddress.isValidIPv4(string.substring(0, n2)) && (IPAddress.isValidIPv4(string2) || IPAddress.isMaskValue(string2, 32));
    }

    public static boolean isValidIPv6WithNetmask(String string) {
        int n2 = string.indexOf("/");
        String string2 = string.substring(n2 + 1);
        return n2 > 0 && IPAddress.isValidIPv6(string.substring(0, n2)) && (IPAddress.isValidIPv6(string2) || IPAddress.isMaskValue(string2, 128));
    }

    private static boolean isMaskValue(String string, int n2) {
        try {
            int n3 = Integer.parseInt(string);
            return n3 >= 0 && n3 <= n2;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isValidIPv6(String string) {
        int n2;
        if (string.length() == 0) {
            return false;
        }
        int n3 = 0;
        String string2 = string + ":";
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < string2.length() && (n2 = string2.indexOf(58, n4)) >= n4) {
            if (n3 == 8) {
                return false;
            }
            if (n4 != n2) {
                String string3 = string2.substring(n4, n2);
                if (n2 == string2.length() - 1 && string3.indexOf(46) > 0) {
                    if (!IPAddress.isValidIPv4(string3)) {
                        return false;
                    }
                    ++n3;
                } else {
                    int n5;
                    try {
                        n5 = Integer.parseInt(string2.substring(n4, n2), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    if (n5 < 0 || n5 > 65535) {
                        return false;
                    }
                }
            } else {
                if (n2 != 1 && n2 != string2.length() - 1 && bl2) {
                    return false;
                }
                bl2 = true;
            }
            n4 = n2 + 1;
            ++n3;
        }
        return n3 == 8 || bl2;
    }
}

