/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.x509;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Encodable;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1GeneralizedTime;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERBitString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AttCertIssuer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Attribute;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AttributeCertificate;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AttributeCertificateInfo;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.V2AttributeCertificateInfoGenerator;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.X509ExtensionsGenerator;
import com.zeroturnaround.bundled.org.bouncycastle.x509.AttributeCertificateHolder;
import com.zeroturnaround.bundled.org.bouncycastle.x509.AttributeCertificateIssuer;
import com.zeroturnaround.bundled.org.bouncycastle.x509.ExtCertificateEncodingException;
import com.zeroturnaround.bundled.org.bouncycastle.x509.X509Attribute;
import com.zeroturnaround.bundled.org.bouncycastle.x509.X509AttributeCertificate;
import com.zeroturnaround.bundled.org.bouncycastle.x509.X509Util;
import com.zeroturnaround.bundled.org.bouncycastle.x509.X509V2AttributeCertificate;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.Date;
import java.util.Iterator;

public class X509V2AttributeCertificateGenerator {
    private V2AttributeCertificateInfoGenerator acInfoGen = new V2AttributeCertificateInfoGenerator();
    private DERObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private X509ExtensionsGenerator extGenerator = new X509ExtensionsGenerator();

    public void reset() {
        this.acInfoGen = new V2AttributeCertificateInfoGenerator();
        this.extGenerator.reset();
    }

    public void setHolder(AttributeCertificateHolder attributeCertificateHolder) {
        this.acInfoGen.setHolder(attributeCertificateHolder.a);
    }

    public void setIssuer(AttributeCertificateIssuer attributeCertificateIssuer) {
        this.acInfoGen.setIssuer(AttCertIssuer.getInstance(attributeCertificateIssuer.a));
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.acInfoGen.setSerialNumber(new ASN1Integer(bigInteger));
    }

    public void setNotBefore(Date date) {
        this.acInfoGen.setStartDate(new ASN1GeneralizedTime(date));
    }

    public void setNotAfter(Date date) {
        this.acInfoGen.setEndDate(new ASN1GeneralizedTime(date));
    }

    public void setSignatureAlgorithm(String string) {
        this.signatureAlgorithm = string;
        try {
            this.sigOID = X509Util.a(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        this.sigAlgId = X509Util.a(this.sigOID, string);
        this.acInfoGen.setSignature(this.sigAlgId);
    }

    public void addAttribute(X509Attribute x509Attribute) {
        this.acInfoGen.addAttribute(Attribute.getInstance(x509Attribute.toASN1Object()));
    }

    public void setIssuerUniqueId(boolean[] blArray) {
        throw new RuntimeException("not implemented (yet)");
    }

    public void addExtension(String string, boolean bl2, ASN1Encodable aSN1Encodable) throws IOException {
        this.extGenerator.addExtension(new ASN1ObjectIdentifier(string), bl2, aSN1Encodable);
    }

    public void addExtension(String string, boolean bl2, byte[] byArray) {
        this.extGenerator.addExtension(new ASN1ObjectIdentifier(string), bl2, byArray);
    }

    public X509AttributeCertificate generateCertificate(PrivateKey privateKey, String string) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateCertificate(privateKey, string, null);
    }

    public X509AttributeCertificate generateCertificate(PrivateKey privateKey, String string, SecureRandom secureRandom) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generate(privateKey, string, secureRandom);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurityException("exception creating certificate: " + generalSecurityException);
        }
    }

    public X509AttributeCertificate generate(PrivateKey privateKey, String string) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        return this.generate(privateKey, string, null);
    }

    public X509AttributeCertificate generate(PrivateKey privateKey, String string, SecureRandom secureRandom) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.extGenerator.isEmpty()) {
            this.acInfoGen.setExtensions(this.extGenerator.generate());
        }
        AttributeCertificateInfo attributeCertificateInfo = this.acInfoGen.generateAttributeCertificateInfo();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(attributeCertificateInfo);
        aSN1EncodableVector.add(this.sigAlgId);
        try {
            aSN1EncodableVector.add(new DERBitString(X509Util.a(this.sigOID, this.signatureAlgorithm, string, privateKey, secureRandom, attributeCertificateInfo)));
            return new X509V2AttributeCertificate(new AttributeCertificate(new DERSequence(aSN1EncodableVector)));
        }
        catch (IOException iOException) {
            throw new ExtCertificateEncodingException("constructed invalid certificate", iOException);
        }
    }

    public Iterator getSignatureAlgNames() {
        return X509Util.a();
    }
}

