/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.x509.extension;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1OctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.x509.extension.X509ExtensionUtil;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PublicKey;

public class SubjectKeyIdentifierStructure
extends SubjectKeyIdentifier {
    public SubjectKeyIdentifierStructure(byte[] byArray) throws IOException {
        super((ASN1OctetString)X509ExtensionUtil.fromExtensionValue(byArray));
    }

    private static ASN1OctetString fromPublicKey(PublicKey publicKey) throws InvalidKeyException {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            return (ASN1OctetString)new SubjectKeyIdentifier(subjectPublicKeyInfo).toASN1Object();
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Exception extracting key details: " + exception.toString());
        }
    }

    public SubjectKeyIdentifierStructure(PublicKey publicKey) throws InvalidKeyException {
        super(SubjectKeyIdentifierStructure.fromPublicKey(publicKey));
    }
}

