/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.liverebel.util;

import com.zeroturnaround.bundled.org.slf4j.Logger;
import com.zeroturnaround.bundled.org.slf4j.LoggerFactory;
import com.zeroturnaround.javarebel.cF;
import com.zeroturnaround.javarebel.cG;
import com.zeroturnaround.javarebel.cH;
import com.zeroturnaround.liverebel.util.AppXmlHandler;
import com.zeroturnaround.liverebel.util.AppXmlParser;
import com.zeroturnaround.liverebel.util.ErrorUtil;
import com.zeroturnaround.liverebel.util.LiveApplicationUtil$1;
import com.zeroturnaround.liverebel.util.LiveApplicationUtil$ApplicationType;
import com.zeroturnaround.liverebel.util.LiveRebelXml;
import com.zeroturnaround.liverebel.util.SanitizeHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.zeroturnaround.zip.ZipUtil;

public class LiveApplicationUtil {
    private static final Logger log;
    public static final String TYPE_JAR = "JAR";
    public static final String TYPE_WAR = "WAR";
    public static final String TYPE_EAR = "EAR";
    public static final String TYPE_ZIP = "ZIP";
    public static final String LIVEREBEL_DIRECTORY = "liverebel";
    private static final String META_INF = "META-INF";
    private static final String WEB_INF = "WEB-INF";
    private static final String CLASSES = "classes";
    public static final String WEB_INF_CLASSES_PREFIX = "WEB-INF/classes/";
    public static final String LIVEREBEL_PREFIX = "liverebel/";
    public static final String META_INF_PREFIX = "META-INF/";
    private static final String[] WAR_ARCHIVE_ENTRIES;
    static Class class$com$zeroturnaround$liverebel$util$LiveApplicationUtil;

    public static LiveApplicationUtil$ApplicationType findApplicationType(File file) {
        return LiveApplicationUtil.findApplicationType(file, null);
    }

    public static LiveApplicationUtil$ApplicationType findApplicationType(File file, String string) {
        LiveApplicationUtil$ApplicationType liveApplicationUtil$ApplicationType = LiveApplicationUtil.findJavaArchiveType(file);
        if (liveApplicationUtil$ApplicationType != null) {
            return liveApplicationUtil$ApplicationType;
        }
        liveApplicationUtil$ApplicationType = LiveApplicationUtil.findApplicationTypeByExtension(string);
        if (liveApplicationUtil$ApplicationType != null) {
            return liveApplicationUtil$ApplicationType;
        }
        return LiveApplicationUtil$ApplicationType.ZIP;
    }

    protected static LiveApplicationUtil$ApplicationType findJavaArchiveType(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Application must be provided.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Application not found: " + file);
        }
        if (file.isDirectory()) {
            File file2 = new File(new File(file, META_INF), "application.xml");
            if (file2.isFile()) {
                return LiveApplicationUtil$ApplicationType.EAR;
            }
            File file3 = new File(file, WEB_INF);
            if (file3.isDirectory()) {
                return LiveApplicationUtil$ApplicationType.WAR;
            }
            File file4 = new File(new File(file, META_INF), "MANIFEST.MF");
            if (file4.isFile()) {
                return LiveApplicationUtil$ApplicationType.JAR;
            }
        } else {
            if (ZipUtil.containsEntry(file, "META-INF/application.xml")) {
                return LiveApplicationUtil$ApplicationType.EAR;
            }
            if (ZipUtil.containsAnyEntry(file, WAR_ARCHIVE_ENTRIES)) {
                return LiveApplicationUtil$ApplicationType.WAR;
            }
            if (ZipUtil.containsEntry(file, "META-INF/MANIFEST.MF")) {
                return LiveApplicationUtil$ApplicationType.JAR;
            }
        }
        return LiveApplicationUtil.findApplicationTypeByExtension(file);
    }

    private static LiveApplicationUtil$ApplicationType findApplicationTypeByExtension(File file) {
        return LiveApplicationUtil.findApplicationTypeByExtension(file.getName());
    }

    private static LiveApplicationUtil$ApplicationType findApplicationTypeByExtension(String string) {
        if (string == null) {
            return null;
        }
        String string2 = cG.a(string);
        if (LiveApplicationUtil$ApplicationType.EAR.name().equalsIgnoreCase(string2)) {
            return LiveApplicationUtil$ApplicationType.EAR;
        }
        if (LiveApplicationUtil$ApplicationType.WAR.name().equalsIgnoreCase(string2)) {
            return LiveApplicationUtil$ApplicationType.WAR;
        }
        if (LiveApplicationUtil$ApplicationType.JAR.name().equalsIgnoreCase(string2)) {
            return LiveApplicationUtil$ApplicationType.JAR;
        }
        return null;
    }

    public static Set findEarModulePaths(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Application must be provided.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Application not found: " + file);
        }
        byte[] byArray = LiveApplicationUtil.getEntry(file, "META-INF/application.xml");
        if (byArray == null) {
            throw new IllegalArgumentException("application.xml not found in '" + file + "'.");
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        AppXmlParser.parse(byArray, (AppXmlHandler)new LiveApplicationUtil$1(linkedHashSet));
        return linkedHashSet;
    }

    public static LiveRebelXml findLiveRebelXml(File file) {
        return LiveApplicationUtil.findLiveRebelXml(file, null);
    }

    public static LiveRebelXml findLiveRebelXml(File file, String string) {
        byte[] byArray = LiveApplicationUtil.findLiveRebelXmlContents(file, string);
        if (byArray == null) {
            return null;
        }
        return LiveRebelXml.parse(byArray);
    }

    public static LiveRebelXml findLiveRebelXml(ZipInputStream zipInputStream) {
        byte[] byArray = LiveApplicationUtil.findLiveRebelXmlContents(zipInputStream);
        if (byArray == null) {
            return null;
        }
        return LiveRebelXml.parse(byArray);
    }

    public static byte[] findLiveRebelXmlContents(File file) {
        return LiveApplicationUtil.findLiveRebelXmlContents(file, null);
    }

    public static byte[] findLiveRebelXmlContents(File file, String string) {
        if (file == null) {
            throw new IllegalArgumentException("Application must be provided.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Application not found: " + file);
        }
        string = string == null ? "" : string + (string.endsWith("/") ? "" : "/");
        LiveApplicationUtil$ApplicationType liveApplicationUtil$ApplicationType = LiveApplicationUtil.findApplicationType(file);
        if (LiveApplicationUtil$ApplicationType.WAR == liveApplicationUtil$ApplicationType) {
            return LiveApplicationUtil.getEntry(file, string + WEB_INF_CLASSES_PREFIX + "liverebel.xml");
        }
        if (LiveApplicationUtil$ApplicationType.ZIP == liveApplicationUtil$ApplicationType) {
            byte[] byArray = LiveApplicationUtil.getEntry(file, string + LIVEREBEL_PREFIX + "liverebel.xml");
            if (byArray == null) {
                return LiveApplicationUtil.getEntry(file, string + "liverebel.xml");
            }
            return byArray;
        }
        return LiveApplicationUtil.getEntry(file, string + "liverebel.xml");
    }

    public static byte[] findLiveRebelXmlContents(ZipInputStream zipInputStream) {
        if (zipInputStream == null) {
            throw new IllegalArgumentException("Application must be provided.");
        }
        byte[] byArray = null;
        String string = "liverebel.xml";
        String string2 = "WEB-INF/classes/liverebel.xml";
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (string.equals(zipEntry.getName()) || string2.equals(zipEntry.getName())) {
                    byArray = cH.a(zipInputStream);
                    break;
                }
                zipInputStream.closeEntry();
            }
        }
        catch (IOException iOException) {
            throw ErrorUtil.rethrow(iOException);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkEarModuleLiveRebelXml(File file) throws IOException {
        Set set = LiveApplicationUtil.findEarModulePaths(file);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LiveRebelXml liveRebelXml = LiveApplicationUtil.findLiveRebelXml(file);
        linkedHashSet.add(liveRebelXml.getApplicationId());
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ZipEntry zipEntry = zipFile.getEntry(string);
                if (zipEntry == null || zipEntry.getSize() <= 0L) continue;
                ZipInputStream zipInputStream = null;
                LiveRebelXml liveRebelXml2 = null;
                try {
                    zipInputStream = new ZipInputStream(new BufferedInputStream(zipFile.getInputStream(zipEntry)));
                    liveRebelXml2 = LiveApplicationUtil.findLiveRebelXml(zipInputStream);
                }
                catch (Throwable throwable) {
                    cH.a(zipInputStream);
                    throw throwable;
                }
                cH.a(zipInputStream);
                if (liveRebelXml2 == null) continue;
                String string2 = liveRebelXml2.getApplicationId();
                if (linkedHashSet.contains(string2)) {
                    throw new IllegalArgumentException("EAR module name in liverebel.xml overlaps with existing module: " + string);
                }
                linkedHashSet.add(string2);
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private static byte[] getEntry(File file, String string) {
        byte[] byArray = null;
        if (file.isDirectory()) {
            File file2 = new File(file, string.replace('/', File.separatorChar));
            log.debug("Checking {}", file2);
            if (file2.exists()) {
                try {
                    byArray = cF.a(file2);
                }
                catch (IOException iOException) {
                    throw ErrorUtil.logAndRethrow(iOException);
                }
            }
        } else {
            log.debug("Looking for {} at {}", (Object)string, (Object)file);
            byArray = ZipUtil.unpackEntry(file, string);
        }
        return byArray;
    }

    public static String getDefaultContextPath(String string) {
        return SanitizeHelper.sanitizeNoHash(string);
    }

    static {
        Class<?> clazz = class$com$zeroturnaround$liverebel$util$LiveApplicationUtil;
        if (clazz == null) {
            clazz = class$com$zeroturnaround$liverebel$util$LiveApplicationUtil = new LiveApplicationUtil[0].getClass().getComponentType();
        }
        log = LoggerFactory.getLogger(clazz);
        WAR_ARCHIVE_ENTRIES = new String[]{"WEB-INF/", "WEB-INF/web.xml", "WEB-INF/classes/liverebel.xml"};
    }
}

