/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassClassPath;
import org.zeroturnaround.bundled.javassist.ClassPath;
import org.zeroturnaround.bundled.javassist.ClassPathList;
import org.zeroturnaround.bundled.javassist.DirClassPath;
import org.zeroturnaround.bundled.javassist.JarClassPath;
import org.zeroturnaround.bundled.javassist.JarDirClassPath;
import org.zeroturnaround.bundled.javassist.NotFoundException;

final class ClassPoolTail {
    protected ClassPathList pathList = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[class path: ");
        ClassPathList classPathList = this.pathList;
        while (classPathList != null) {
            stringBuffer.append(classPathList.path.toString());
            stringBuffer.append(File.pathSeparatorChar);
            classPathList = classPathList.next;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public synchronized ClassPath insertClassPath(ClassPath classPath) {
        this.pathList = new ClassPathList(classPath, this.pathList);
        return classPath;
    }

    public synchronized ClassPath appendClassPath(ClassPath classPath) {
        ClassPathList classPathList = new ClassPathList(classPath, null);
        ClassPathList classPathList2 = this.pathList;
        if (classPathList2 == null) {
            this.pathList = classPathList;
        } else {
            while (classPathList2.next != null) {
                classPathList2 = classPathList2.next;
            }
            classPathList2.next = classPathList;
        }
        return classPath;
    }

    public synchronized void removeClassPath(ClassPath classPath) {
        ClassPathList classPathList = this.pathList;
        if (classPathList != null) {
            if (classPathList.path == classPath) {
                this.pathList = classPathList.next;
            } else {
                while (classPathList.next != null) {
                    if (classPathList.next.path == classPath) {
                        classPathList.next = classPathList.next.next;
                        continue;
                    }
                    classPathList = classPathList.next;
                }
            }
        }
        classPath.close();
    }

    public ClassPath appendSystemPath() {
        return this.appendClassPath(new ClassClassPath());
    }

    public ClassPath insertClassPath(String string) throws NotFoundException {
        return this.insertClassPath(ClassPoolTail.makePathObject(string));
    }

    public ClassPath appendClassPath(String string) throws NotFoundException {
        return this.appendClassPath(ClassPoolTail.makePathObject(string));
    }

    private static ClassPath makePathObject(String string) throws NotFoundException {
        String string2 = string.toLowerCase();
        if (string2.endsWith(".jar") || string2.endsWith(".zip")) {
            return new JarClassPath(string);
        }
        int n2 = string.length();
        if (n2 > 2 && string.charAt(n2 - 1) == '*' && (string.charAt(n2 - 2) == '/' || string.charAt(n2 - 2) == File.separatorChar)) {
            String string3 = string.substring(0, n2 - 2);
            return new JarDirClassPath(string3);
        }
        return new DirClassPath(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeClassfile(String string, OutputStream outputStream) throws NotFoundException, IOException, CannotCompileException {
        InputStream inputStream = this.openClassfile(string);
        if (inputStream == null) {
            throw new NotFoundException(string);
        }
        try {
            ClassPoolTail.copyStream(inputStream, outputStream);
        }
        finally {
            inputStream.close();
        }
    }

    InputStream openClassfile(String string) throws NotFoundException {
        ClassPathList classPathList = this.pathList;
        InputStream inputStream = null;
        NotFoundException notFoundException = null;
        while (classPathList != null) {
            block5: {
                try {
                    inputStream = classPathList.path.openClassfile(string);
                }
                catch (NotFoundException notFoundException2) {
                    if (notFoundException != null) break block5;
                    notFoundException = notFoundException2;
                }
            }
            if (inputStream == null) {
                classPathList = classPathList.next;
                continue;
            }
            return inputStream;
        }
        if (notFoundException != null) {
            throw notFoundException;
        }
        return null;
    }

    public URL find(String string) {
        ClassPathList classPathList = this.pathList;
        URL uRL = null;
        while (classPathList != null) {
            uRL = classPathList.path.find(string);
            if (uRL == null) {
                classPathList = classPathList.next;
                continue;
            }
            return uRL;
        }
        return null;
    }

    public static byte[] readStream(InputStream inputStream) throws IOException {
        byte[][] byArrayArray = new byte[8][];
        int n2 = 4096;
        for (int i2 = 0; i2 < 8; ++i2) {
            byArrayArray[i2] = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            do {
                if ((n4 = inputStream.read(byArrayArray[i2], n3, n2 - n3)) >= 0) continue;
                byte[] byArray = new byte[n2 - 4096 + n3];
                int n5 = 0;
                for (int i3 = 0; i3 < i2; ++i3) {
                    System.arraycopy(byArrayArray[i3], 0, byArray, n5, n5 + 4096);
                    n5 = n5 + n5 + 4096;
                }
                System.arraycopy(byArrayArray[i2], 0, byArray, n5, n3);
                return byArray;
            } while ((n3 += n4) < n2);
            n2 *= 2;
        }
        throw new IOException("too much data");
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2 = 4096;
        byte[] byArray = null;
        for (int i2 = 0; i2 < 64; ++i2) {
            if (i2 < 8) {
                byArray = new byte[n2 *= 2];
            }
            int n3 = 0;
            int n4 = 0;
            do {
                if ((n4 = inputStream.read(byArray, n3, n2 - n3)) >= 0) continue;
                outputStream.write(byArray, 0, n3);
                return;
            } while ((n3 += n4) < n2);
            outputStream.write(byArray);
        }
        throw new IOException("too much data");
    }
}

