/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;

final class CtArray
extends CtClass {
    protected ClassPool pool;
    private CtClass[] interfaces = null;
    static Class array$Ljava$lang$Object;

    CtArray(String string, ClassPool classPool) {
        super(string);
        this.pool = classPool;
    }

    public ClassPool getClassPool() {
        return this.pool;
    }

    public boolean isArray() {
        return true;
    }

    public int getModifiers() {
        int n2 = 16;
        try {
            n2 |= this.getComponentType().getModifiers() & 7;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return n2;
    }

    public CtClass[] getInterfaces() throws NotFoundException {
        if (this.interfaces == null) {
            Class<?>[] classArray = (array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = CtArray.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object).getInterfaces();
            this.interfaces = new CtClass[classArray.length];
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                this.interfaces[i2] = this.pool.get(classArray[i2].getName());
            }
        }
        return this.interfaces;
    }

    public boolean subtypeOf(CtClass ctClass) throws NotFoundException {
        if (super.subtypeOf(ctClass)) {
            return true;
        }
        String string = ctClass.getName();
        if (string.equals("java.lang.Object")) {
            return true;
        }
        CtClass[] ctClassArray = this.getInterfaces();
        for (int i2 = 0; i2 < ctClassArray.length; ++i2) {
            if (!ctClassArray[i2].subtypeOf(ctClass)) continue;
            return true;
        }
        return ctClass.isArray() && this.getComponentType().subtypeOf(ctClass.getComponentType());
    }

    public CtClass getComponentType() throws NotFoundException {
        String string = this.getName();
        return this.pool.get(string.substring(0, string.length() - 2));
    }

    public CtClass getSuperclass() throws NotFoundException {
        return this.pool.get("java.lang.Object");
    }

    public CtMethod[] getMethods() {
        try {
            return this.getSuperclass().getMethods();
        }
        catch (NotFoundException notFoundException) {
            return super.getMethods();
        }
    }

    public CtMethod getMethod(String string, String string2) throws NotFoundException {
        return this.getSuperclass().getMethod(string, string2);
    }

    public CtConstructor[] getConstructors() {
        try {
            return this.getSuperclass().getConstructors();
        }
        catch (NotFoundException notFoundException) {
            return super.getConstructors();
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

