/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import java.util.ListIterator;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtClassType;
import org.zeroturnaround.bundled.javassist.CtField$Initializer;
import org.zeroturnaround.bundled.javassist.CtMember;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.AccessFlag;
import org.zeroturnaround.bundled.javassist.bytecode.AnnotationsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.AttributeInfo;
import org.zeroturnaround.bundled.javassist.bytecode.ClassFile;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.FieldInfo;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.Javac;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTree;

public class CtField
extends CtMember {
    static final String javaLangString = "java.lang.String";
    protected FieldInfo fieldInfo;

    public CtField(CtClass ctClass, String string, CtClass ctClass2) throws CannotCompileException {
        this(Descriptor.of(ctClass), string, ctClass2);
    }

    public CtField(CtField ctField, CtClass ctClass) throws CannotCompileException {
        this(ctField.fieldInfo.getDescriptor(), ctField.fieldInfo.getName(), ctClass);
        ListIterator listIterator = ctField.fieldInfo.getAttributes().listIterator();
        FieldInfo fieldInfo = this.fieldInfo;
        fieldInfo.setAccessFlags(ctField.fieldInfo.getAccessFlags());
        ConstPool constPool = fieldInfo.getConstPool();
        while (listIterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)listIterator.next();
            fieldInfo.addAttribute(attributeInfo.copy(constPool, null));
        }
    }

    private CtField(String string, String string2, CtClass ctClass) throws CannotCompileException {
        super(ctClass);
        ClassFile classFile = ctClass.getClassFile2();
        if (classFile == null) {
            throw new CannotCompileException("bad declaring class: " + ctClass.getName());
        }
        this.fieldInfo = new FieldInfo(classFile.getConstPool(), string2, string);
    }

    CtField(FieldInfo fieldInfo, CtClass ctClass) {
        super(ctClass);
        this.fieldInfo = fieldInfo;
    }

    public String toString() {
        return this.getDeclaringClass().getName() + "." + this.getName() + ":" + this.fieldInfo.getDescriptor();
    }

    protected void extendToString(StringBuffer stringBuffer) {
        stringBuffer.append(' ');
        stringBuffer.append(this.getName());
        stringBuffer.append(' ');
        stringBuffer.append(this.fieldInfo.getDescriptor());
    }

    protected ASTree getInitAST() {
        return null;
    }

    CtField$Initializer getInit() {
        ASTree aSTree = this.getInitAST();
        if (aSTree == null) {
            return null;
        }
        return CtField$Initializer.byExpr(aSTree);
    }

    public static CtField make(String string, CtClass ctClass) throws CannotCompileException {
        Javac javac = new Javac(ctClass);
        try {
            CtMember ctMember = javac.compile(string);
            if (ctMember instanceof CtField) {
                return (CtField)ctMember;
            }
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        throw new CannotCompileException("not a field");
    }

    public FieldInfo getFieldInfo() {
        this.declaringClass.checkModify();
        return this.fieldInfo;
    }

    public FieldInfo getFieldInfo2() {
        return this.fieldInfo;
    }

    public CtClass getDeclaringClass() {
        return super.getDeclaringClass();
    }

    public String getName() {
        return this.fieldInfo.getName();
    }

    public void setName(String string) {
        this.declaringClass.checkModify();
        this.fieldInfo.setName(string);
    }

    public int getModifiers() {
        return AccessFlag.toModifier(this.fieldInfo.getAccessFlags());
    }

    public void setModifiers(int n2) {
        this.declaringClass.checkModify();
        this.fieldInfo.setAccessFlags(AccessFlag.of(n2));
    }

    public boolean hasAnnotation(Class clazz) {
        FieldInfo fieldInfo = this.getFieldInfo2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.hasAnnotationType(clazz, this.getDeclaringClass().getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    public Object getAnnotation(Class clazz) throws ClassNotFoundException {
        FieldInfo fieldInfo = this.getFieldInfo2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.getAnnotationType(clazz, this.getDeclaringClass().getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    public Object[] getAnnotations() throws ClassNotFoundException {
        return this.getAnnotations(false);
    }

    public Object[] getAvailableAnnotations() {
        try {
            return this.getAnnotations(true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unexpected exception", classNotFoundException);
        }
    }

    private Object[] getAnnotations(boolean bl2) throws ClassNotFoundException {
        FieldInfo fieldInfo = this.getFieldInfo2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.toAnnotationType(bl2, this.getDeclaringClass().getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    public String getSignature() {
        return this.fieldInfo.getDescriptor();
    }

    public String getGenericSignature() {
        SignatureAttribute signatureAttribute = (SignatureAttribute)this.fieldInfo.getAttribute("Signature");
        return signatureAttribute == null ? null : signatureAttribute.getSignature();
    }

    public void setGenericSignature(String string) {
        this.declaringClass.checkModify();
        this.fieldInfo.addAttribute(new SignatureAttribute(this.fieldInfo.getConstPool(), string));
    }

    public CtClass getType() throws NotFoundException {
        return Descriptor.toCtClass(this.fieldInfo.getDescriptor(), this.declaringClass.getClassPool());
    }

    public void setType(CtClass ctClass) {
        this.declaringClass.checkModify();
        this.fieldInfo.setDescriptor(Descriptor.of(ctClass));
    }

    public Object getConstantValue() {
        int n2 = this.fieldInfo.getConstantValue();
        if (n2 == 0) {
            return null;
        }
        ConstPool constPool = this.fieldInfo.getConstPool();
        switch (constPool.getTag(n2)) {
            case 5: {
                return new Long(constPool.getLongInfo(n2));
            }
            case 4: {
                return new Float(constPool.getFloatInfo(n2));
            }
            case 6: {
                return new Double(constPool.getDoubleInfo(n2));
            }
            case 3: {
                int n3 = constPool.getIntegerInfo(n2);
                if ("Z".equals(this.fieldInfo.getDescriptor())) {
                    return new Boolean(n3 != 0);
                }
                return new Integer(n3);
            }
            case 8: {
                return constPool.getStringInfo(n2);
            }
        }
        throw new RuntimeException("bad tag: " + constPool.getTag(n2) + " at " + n2);
    }

    public byte[] getAttribute(String string) {
        AttributeInfo attributeInfo = this.fieldInfo.getAttribute(string);
        if (attributeInfo == null) {
            return null;
        }
        return attributeInfo.get();
    }

    public void setAttribute(String string, byte[] byArray) {
        this.declaringClass.checkModify();
        this.fieldInfo.addAttribute(new AttributeInfo(this.fieldInfo.getConstPool(), string, byArray));
    }
}

