/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.zeroturnaround.bundled.javassist.ClassPath;
import org.zeroturnaround.bundled.javassist.NotFoundException;

final class JarClassPath
implements ClassPath {
    JarFile jarfile;
    String jarfileURL;

    JarClassPath(String string) throws NotFoundException {
        try {
            this.jarfile = new JarFile(string);
            this.jarfileURL = new File(string).getCanonicalFile().toURI().toURL().toString();
            return;
        }
        catch (IOException iOException) {
            throw new NotFoundException(string);
        }
    }

    public InputStream openClassfile(String string) throws NotFoundException {
        try {
            String string2 = string.replace('.', '/') + ".class";
            JarEntry jarEntry = this.jarfile.getJarEntry(string2);
            if (jarEntry != null) {
                return this.jarfile.getInputStream(jarEntry);
            }
            return null;
        }
        catch (IOException iOException) {
            throw new NotFoundException("broken jar file?: " + this.jarfile.getName());
        }
    }

    public URL find(String string) {
        String string2 = string.replace('.', '/') + ".class";
        JarEntry jarEntry = this.jarfile.getJarEntry(string2);
        if (jarEntry != null) {
            try {
                return new URL("jar:" + this.jarfileURL + "!/" + string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public void close() {
        try {
            this.jarfile.close();
            this.jarfile = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.jarfile == null ? "<null>" : this.jarfile.toString();
    }
}

