/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.zeroturnaround.bundled.javassist.bytecode.AnnotationDefaultAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.AnnotationsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.BootstrapMethodsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstantAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.DeprecatedAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.EnclosingMethodAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.InnerClassesAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LineNumberAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LocalVariableAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LocalVariableTypeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.ParameterAnnotationsAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.SignatureAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.SourceFileAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.StackMap;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable;
import org.zeroturnaround.bundled.javassist.bytecode.SyntheticAttribute;

public class AttributeInfo {
    protected ConstPool constPool;
    int name;
    byte[] info;

    protected AttributeInfo(ConstPool constPool, int n2, byte[] byArray) {
        this.constPool = constPool;
        this.name = n2;
        this.info = byArray;
    }

    protected AttributeInfo(ConstPool constPool, String string) {
        this(constPool, string, (byte[])null);
    }

    public AttributeInfo(ConstPool constPool, String string, byte[] byArray) {
        this(constPool, constPool.addUtf8Info(string), byArray);
    }

    protected AttributeInfo(ConstPool constPool, int n2, DataInputStream dataInputStream) throws IOException {
        this.constPool = constPool;
        this.name = n2;
        int n3 = dataInputStream.readInt();
        this.info = new byte[n3];
        if (n3 > 0) {
            dataInputStream.readFully(this.info);
        }
    }

    static AttributeInfo read(ConstPool constPool, DataInputStream dataInputStream) throws IOException {
        int n2 = dataInputStream.readUnsignedShort();
        String string = constPool.getUtf8Info(n2);
        if (string.charAt(0) < 'L') {
            if (string.equals("AnnotationDefault")) {
                return new AnnotationDefaultAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("BootstrapMethods")) {
                return new BootstrapMethodsAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("Code")) {
                return new CodeAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("ConstantValue")) {
                return new ConstantAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("Deprecated")) {
                return new DeprecatedAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("EnclosingMethod")) {
                return new EnclosingMethodAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("Exceptions")) {
                return new ExceptionsAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("InnerClasses")) {
                return new InnerClassesAttribute(constPool, n2, dataInputStream);
            }
        } else {
            if (string.equals("LineNumberTable")) {
                return new LineNumberAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("LocalVariableTable")) {
                return new LocalVariableAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("LocalVariableTypeTable")) {
                return new LocalVariableTypeAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("RuntimeVisibleAnnotations") || string.equals("RuntimeInvisibleAnnotations")) {
                return new AnnotationsAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("RuntimeVisibleParameterAnnotations") || string.equals("RuntimeInvisibleParameterAnnotations")) {
                return new ParameterAnnotationsAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("Signature")) {
                return new SignatureAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("SourceFile")) {
                return new SourceFileAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("Synthetic")) {
                return new SyntheticAttribute(constPool, n2, dataInputStream);
            }
            if (string.equals("StackMap")) {
                return new StackMap(constPool, n2, dataInputStream);
            }
            if (string.equals("StackMapTable")) {
                return new StackMapTable(constPool, n2, dataInputStream);
            }
        }
        return new AttributeInfo(constPool, n2, dataInputStream);
    }

    public String getName() {
        return this.constPool.getUtf8Info(this.name);
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public int length() {
        return this.info.length + 6;
    }

    public byte[] get() {
        return this.info;
    }

    public void set(byte[] byArray) {
        this.info = byArray;
    }

    public AttributeInfo copy(ConstPool constPool, Map map) {
        int n2 = this.info.length;
        byte[] byArray = this.info;
        byte[] byArray2 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray2[i2] = byArray[i2];
        }
        return new AttributeInfo(constPool, this.getName(), byArray2);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name);
        dataOutputStream.writeInt(this.info.length);
        if (this.info.length > 0) {
            dataOutputStream.write(this.info);
        }
    }

    static int getLength(ArrayList arrayList) {
        int n2 = 0;
        int n3 = arrayList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            AttributeInfo attributeInfo = (AttributeInfo)arrayList.get(i2);
            n2 += attributeInfo.length();
        }
        return n2;
    }

    static AttributeInfo lookup(ArrayList arrayList, String string) {
        if (arrayList == null) {
            return null;
        }
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)listIterator.next();
            if (!attributeInfo.getName().equals(string)) continue;
            return attributeInfo;
        }
        return null;
    }

    static synchronized void remove(ArrayList arrayList, String string) {
        if (arrayList == null) {
            return;
        }
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)listIterator.next();
            if (!attributeInfo.getName().equals(string)) continue;
            listIterator.remove();
        }
    }

    static void writeAll(ArrayList arrayList, DataOutputStream dataOutputStream) throws IOException {
        if (arrayList == null) {
            return;
        }
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AttributeInfo attributeInfo = (AttributeInfo)arrayList.get(i2);
            attributeInfo.write(dataOutputStream);
        }
    }

    static ArrayList copyAll(ArrayList arrayList, ConstPool constPool) {
        if (arrayList == null) {
            return null;
        }
        ArrayList<AttributeInfo> arrayList2 = new ArrayList<AttributeInfo>();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AttributeInfo attributeInfo = (AttributeInfo)arrayList.get(i2);
            arrayList2.add(attributeInfo.copy(constPool, null));
        }
        return arrayList2;
    }

    void renameClass(String string, String string2) {
    }

    void renameClass(Map map) {
    }

    static void renameClass(List list, String string, String string2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)iterator.next();
            attributeInfo.renameClass(string, string2);
        }
    }

    static void renameClass(List list, Map map) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)iterator.next();
            attributeInfo.renameClass(map);
        }
    }

    void getRefClasses(Map map) {
    }

    static void getRefClasses(List list, Map map) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)iterator.next();
            attributeInfo.getRefClasses(map);
        }
    }
}

