/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.IOException;
import java.io.OutputStream;

final class ByteStream
extends OutputStream {
    private byte[] buf;
    private int count;

    public ByteStream() {
        this(32);
    }

    public ByteStream(int n2) {
        this.buf = new byte[n2];
        this.count = 0;
    }

    public int getPos() {
        return this.count;
    }

    public int size() {
        return this.count;
    }

    public void writeBlank(int n2) {
        this.enlarge(n2);
        this.count += n2;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.enlarge(n3);
        System.arraycopy(byArray, n2, this.buf, this.count, n3);
        this.count += n3;
    }

    public void write(int n2) {
        this.enlarge(1);
        int n3 = this.count;
        this.buf[n3] = (byte)n2;
        this.count = n3 + 1;
    }

    public void writeShort(int n2) {
        this.enlarge(2);
        int n3 = this.count;
        this.buf[n3] = (byte)(n2 >>> 8);
        this.buf[n3 + 1] = (byte)n2;
        this.count = n3 + 2;
    }

    public void writeInt(int n2) {
        this.enlarge(4);
        int n3 = this.count;
        this.buf[n3] = (byte)(n2 >>> 24);
        this.buf[n3 + 1] = (byte)(n2 >>> 16);
        this.buf[n3 + 2] = (byte)(n2 >>> 8);
        this.buf[n3 + 3] = (byte)n2;
        this.count = n3 + 4;
    }

    public void writeLong(long l2) {
        this.enlarge(8);
        int n2 = this.count;
        this.buf[n2] = (byte)(l2 >>> 56);
        this.buf[n2 + 1] = (byte)(l2 >>> 48);
        this.buf[n2 + 2] = (byte)(l2 >>> 40);
        this.buf[n2 + 3] = (byte)(l2 >>> 32);
        this.buf[n2 + 4] = (byte)(l2 >>> 24);
        this.buf[n2 + 5] = (byte)(l2 >>> 16);
        this.buf[n2 + 6] = (byte)(l2 >>> 8);
        this.buf[n2 + 7] = (byte)l2;
        this.count = n2 + 8;
    }

    public void writeFloat(float f2) {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public void writeDouble(double d2) {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public void writeUTF(String string) {
        int n2 = string.length();
        int n3 = this.count;
        this.enlarge(n2 + 2);
        byte[] byArray = this.buf;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if ('\u0001' > c2 || c2 > '\u007f') {
                this.writeUTF2(string, n2, i2);
                return;
            }
            byArray[n3++] = (byte)c2;
        }
        this.count = n3;
    }

    private void writeUTF2(String string, int n2, int n3) {
        int n4;
        int n5 = n2;
        for (n4 = n3; n4 < n2; ++n4) {
            char c2 = string.charAt(n4);
            if (c2 > '\u07ff') {
                n5 += 2;
                continue;
            }
            if (c2 != '\u0000' && c2 <= '\u007f') continue;
            ++n5;
        }
        if (n5 > 65535) {
            throw new RuntimeException("encoded string too long: " + n2 + n5 + " bytes");
        }
        this.enlarge(n5 + 2);
        n4 = this.count;
        byte[] byArray = this.buf;
        byArray[n4] = (byte)(n5 >>> 8);
        byArray[n4 + 1] = (byte)n5;
        n4 += 2 + n3;
        for (int i2 = n3; i2 < n2; ++i2) {
            char c3 = string.charAt(i2);
            if ('\u0001' <= c3 && c3 <= '\u007f') {
                byArray[n4++] = (byte)c3;
                continue;
            }
            if (c3 > '\u07ff') {
                byArray[n4] = (byte)(0xE0 | c3 >> 12 & 0xF);
                byArray[n4 + 1] = (byte)(0x80 | c3 >> 6 & 0x3F);
                byArray[n4 + 2] = (byte)(0x80 | c3 & 0x3F);
                n4 += 3;
                continue;
            }
            byArray[n4] = (byte)(0xC0 | c3 >> 6 & 0x1F);
            byArray[n4 + 1] = (byte)(0x80 | c3 & 0x3F);
            n4 += 2;
        }
        this.count = n4;
    }

    public void write(int n2, int n3) {
        this.buf[n2] = (byte)n3;
    }

    public void writeShort(int n2, int n3) {
        this.buf[n2] = (byte)(n3 >>> 8);
        this.buf[n2 + 1] = (byte)n3;
    }

    public void writeInt(int n2, int n3) {
        this.buf[n2] = (byte)(n3 >>> 24);
        this.buf[n2 + 1] = (byte)(n3 >>> 16);
        this.buf[n2 + 2] = (byte)(n3 >>> 8);
        this.buf[n2 + 3] = (byte)n3;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public void enlarge(int n2) {
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            int n4 = this.buf.length << 1;
            byte[] byArray = new byte[n4 > n3 ? n4 : n3];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
    }
}

