/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.util.ArrayList;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute$LdcEntry;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator$AlignmentException;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator$Branch;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator$Branch16;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator$Gap;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator$If16;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator$Jump16;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator$Jump32;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator$LdcW;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator$Lookup;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator$Pointers;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator$Table;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.ExceptionTable;
import org.zeroturnaround.bundled.javassist.bytecode.LineNumberAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LocalVariableAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;
import org.zeroturnaround.bundled.javassist.bytecode.StackMap;
import org.zeroturnaround.bundled.javassist.bytecode.StackMapTable;

public class CodeIterator
implements Opcode {
    protected CodeAttribute codeAttr;
    protected byte[] bytecode;
    protected int endPos;
    protected int currentPos;
    protected int mark;
    private static final int[] opcodeLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 0, 0, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 5, 3, 2, 3, 1, 1, 3, 3, 1, 1, 0, 4, 3, 3, 5, 5};

    protected CodeIterator(CodeAttribute codeAttribute) {
        this.codeAttr = codeAttribute;
        this.bytecode = codeAttribute.getCode();
        this.begin();
    }

    public void begin() {
        this.mark = 0;
        this.currentPos = 0;
        this.endPos = this.getCodeLength();
    }

    public void move(int n2) {
        this.currentPos = n2;
    }

    public void setMark(int n2) {
        this.mark = n2;
    }

    public int getMark() {
        return this.mark;
    }

    public CodeAttribute get() {
        return this.codeAttr;
    }

    public int getCodeLength() {
        return this.bytecode.length;
    }

    public int byteAt(int n2) {
        return this.bytecode[n2] & 0xFF;
    }

    public void writeByte(int n2, int n3) {
        this.bytecode[n3] = (byte)n2;
    }

    public int u16bitAt(int n2) {
        return ByteArray.readU16bit(this.bytecode, n2);
    }

    public int s16bitAt(int n2) {
        return ByteArray.readS16bit(this.bytecode, n2);
    }

    public void write16bit(int n2, int n3) {
        ByteArray.write16bit(n2, this.bytecode, n3);
    }

    public int s32bitAt(int n2) {
        return ByteArray.read32bit(this.bytecode, n2);
    }

    public void write32bit(int n2, int n3) {
        ByteArray.write32bit(n2, this.bytecode, n3);
    }

    public void write(byte[] byArray, int n2) {
        int n3 = byArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.bytecode[n2++] = byArray[i2];
        }
    }

    public boolean hasNext() {
        return this.currentPos < this.endPos;
    }

    public int next() throws BadBytecode {
        int n2 = this.currentPos;
        this.currentPos = CodeIterator.nextOpcode(this.bytecode, n2);
        return n2;
    }

    public int lookAhead() {
        return this.currentPos;
    }

    public int skipConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(-1);
    }

    public int skipSuperConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(0);
    }

    public int skipThisConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(1);
    }

    private int skipSuperConstructor0(int n2) throws BadBytecode {
        this.begin();
        ConstPool constPool = this.codeAttr.getConstPool();
        String string = this.codeAttr.getDeclaringClass();
        int n3 = 0;
        while (this.hasNext()) {
            int n4;
            int n5 = this.next();
            int n6 = this.byteAt(n5);
            if (n6 == 187) {
                ++n3;
                continue;
            }
            if (n6 != 183 || !constPool.getMethodrefName(n4 = ByteArray.readU16bit(this.bytecode, n5 + 1)).equals("<init>") || --n3 >= 0) continue;
            if (n2 < 0) {
                return n5;
            }
            String string2 = constPool.getMethodrefClassName(n4);
            if (string2.equals(string) != n2 > 0) break;
            return n5;
        }
        this.begin();
        return -1;
    }

    public int insert(byte[] byArray) throws BadBytecode {
        return this.insert0(this.currentPos, byArray, false);
    }

    public void insert(int n2, byte[] byArray) throws BadBytecode {
        this.insert0(n2, byArray, false);
    }

    public int insertAt(int n2, byte[] byArray) throws BadBytecode {
        return this.insert0(n2, byArray, false);
    }

    public int insertEx(byte[] byArray) throws BadBytecode {
        return this.insert0(this.currentPos, byArray, true);
    }

    public void insertEx(int n2, byte[] byArray) throws BadBytecode {
        this.insert0(n2, byArray, true);
    }

    public int insertExAt(int n2, byte[] byArray) throws BadBytecode {
        return this.insert0(n2, byArray, true);
    }

    private int insert0(int n2, byte[] byArray, boolean bl2) throws BadBytecode {
        int n3 = byArray.length;
        if (n3 <= 0) {
            return n2;
        }
        int n4 = n2 = this.insertGapAt((int)n2, (int)n3, (boolean)bl2).position;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.bytecode[n4++] = byArray[i2];
        }
        return n2;
    }

    public int insertGap(int n2) throws BadBytecode {
        return this.insertGapAt((int)this.currentPos, (int)n2, (boolean)false).position;
    }

    public int insertGap(int n2, int n3) throws BadBytecode {
        return this.insertGapAt((int)n2, (int)n3, (boolean)false).length;
    }

    public int insertExGap(int n2) throws BadBytecode {
        return this.insertGapAt((int)this.currentPos, (int)n2, (boolean)true).position;
    }

    public int insertExGap(int n2, int n3) throws BadBytecode {
        return this.insertGapAt((int)n2, (int)n3, (boolean)true).length;
    }

    public CodeIterator$Gap insertGapAt(int n2, int n3, boolean bl2) throws BadBytecode {
        int n4;
        byte[] byArray;
        CodeIterator$Gap codeIterator$Gap = new CodeIterator$Gap();
        if (n3 <= 0) {
            codeIterator$Gap.position = n2;
            codeIterator$Gap.length = 0;
            return codeIterator$Gap;
        }
        if (this.bytecode.length + n3 > Short.MAX_VALUE) {
            byArray = this.insertGapCore0w(this.bytecode, n2, n3, bl2, this.get().getExceptionTable(), this.codeAttr, codeIterator$Gap);
            n2 = codeIterator$Gap.position;
            n4 = n3;
        } else {
            int n5 = this.currentPos;
            byArray = CodeIterator.insertGapCore0(this.bytecode, n2, n3, bl2, this.get().getExceptionTable(), this.codeAttr);
            n4 = byArray.length - this.bytecode.length;
            codeIterator$Gap.position = n2;
            codeIterator$Gap.length = n4;
            if (n5 >= n2) {
                this.currentPos = n5 + n4;
            }
            if (this.mark > n2 || this.mark == n2 && bl2) {
                this.mark += n4;
            }
        }
        this.codeAttr.setCode(byArray);
        this.bytecode = byArray;
        this.endPos = this.getCodeLength();
        this.updateCursors(n2, n4);
        return codeIterator$Gap;
    }

    protected void updateCursors(int n2, int n3) {
    }

    public void insert(ExceptionTable exceptionTable, int n2) {
        this.codeAttr.getExceptionTable().add(0, exceptionTable, n2);
    }

    public int append(byte[] byArray) {
        int n2 = this.getCodeLength();
        int n3 = byArray.length;
        if (n3 <= 0) {
            return n2;
        }
        this.appendGap(n3);
        byte[] byArray2 = this.bytecode;
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray2[i2 + n2] = byArray[i2];
        }
        return n2;
    }

    public void appendGap(int n2) {
        int n3;
        byte[] byArray = this.bytecode;
        int n4 = byArray.length;
        byte[] byArray2 = new byte[n4 + n2];
        for (n3 = 0; n3 < n4; ++n3) {
            byArray2[n3] = byArray[n3];
        }
        for (n3 = n4; n3 < n4 + n2; ++n3) {
            byArray2[n3] = 0;
        }
        this.codeAttr.setCode(byArray2);
        this.bytecode = byArray2;
        this.endPos = this.getCodeLength();
    }

    public void append(ExceptionTable exceptionTable, int n2) {
        ExceptionTable exceptionTable2 = this.codeAttr.getExceptionTable();
        exceptionTable2.add(exceptionTable2.size(), exceptionTable, n2);
    }

    static int nextOpcode(byte[] byArray, int n2) throws BadBytecode {
        int n3;
        try {
            n3 = byArray[n2] & 0xFF;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new BadBytecode("invalid opcode address");
        }
        try {
            int n4 = opcodeLength[n3];
            if (n4 > 0) {
                return n2 + n4;
            }
            if (n3 == 196) {
                if (byArray[n2 + 1] == -124) {
                    return n2 + 6;
                }
                return n2 + 4;
            }
            int n5 = (n2 & 0xFFFFFFFC) + 8;
            if (n3 == 171) {
                int n6 = ByteArray.read32bit(byArray, n5);
                return n5 + n6 * 8 + 4;
            }
            if (n3 == 170) {
                int n7 = ByteArray.read32bit(byArray, n5);
                int n8 = ByteArray.read32bit(byArray, n5 + 4);
                return n5 + (n8 - n7 + 1) * 4 + 8;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new BadBytecode(n3);
    }

    static byte[] insertGapCore0(byte[] byArray, int n2, int n3, boolean bl2, ExceptionTable exceptionTable, CodeAttribute codeAttribute) throws BadBytecode {
        if (n3 <= 0) {
            return byArray;
        }
        try {
            return CodeIterator.insertGapCore1(byArray, n2, n3, bl2, exceptionTable, codeAttribute);
        }
        catch (CodeIterator$AlignmentException codeIterator$AlignmentException) {
            try {
                return CodeIterator.insertGapCore1(byArray, n2, n3 + 3 & 0xFFFFFFFC, bl2, exceptionTable, codeAttribute);
            }
            catch (CodeIterator$AlignmentException codeIterator$AlignmentException2) {
                throw new RuntimeException("fatal error?");
            }
        }
    }

    private static byte[] insertGapCore1(byte[] byArray, int n2, int n3, boolean bl2, ExceptionTable exceptionTable, CodeAttribute codeAttribute) throws BadBytecode, CodeIterator$AlignmentException {
        StackMap stackMap;
        StackMapTable stackMapTable;
        LocalVariableAttribute localVariableAttribute;
        LocalVariableAttribute localVariableAttribute2;
        int n4 = byArray.length;
        byte[] byArray2 = new byte[n4 + n3];
        CodeIterator.insertGap2(byArray, n2, n3, n4, byArray2, bl2);
        exceptionTable.shiftPc(n2, n3, bl2);
        LineNumberAttribute lineNumberAttribute = (LineNumberAttribute)codeAttribute.getAttribute("LineNumberTable");
        if (lineNumberAttribute != null) {
            lineNumberAttribute.shiftPc(n2, n3, bl2);
        }
        if ((localVariableAttribute2 = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable")) != null) {
            localVariableAttribute2.shiftPc(n2, n3, bl2);
        }
        if ((localVariableAttribute = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTypeTable")) != null) {
            localVariableAttribute.shiftPc(n2, n3, bl2);
        }
        if ((stackMapTable = (StackMapTable)codeAttribute.getAttribute("StackMapTable")) != null) {
            stackMapTable.shiftPc(n2, n3, bl2);
        }
        if ((stackMap = (StackMap)codeAttribute.getAttribute("StackMap")) != null) {
            stackMap.shiftPc(n2, n3, bl2);
        }
        return byArray2;
    }

    private static void insertGap2(byte[] byArray, int n2, int n3, int n4, byte[] byArray2, boolean bl2) throws BadBytecode, CodeIterator$AlignmentException {
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            if (n5 == n2) {
                n12 = n6 + n3;
                while (n6 < n12) {
                    byArray2[n6++] = 0;
                }
            }
            int n13 = CodeIterator.nextOpcode(byArray, n5);
            n12 = byArray[n5] & 0xFF;
            if (153 <= n12 && n12 <= 168 || n12 == 198 || n12 == 199) {
                n11 = byArray[n5 + 1] << 8 | byArray[n5 + 2] & 0xFF;
                n11 = CodeIterator.newOffset(n5, n11, n2, n3, bl2);
                byArray2[n6] = byArray[n5];
                ByteArray.write16bit(n11, byArray2, n6 + 1);
                n6 += 3;
            } else if (n12 == 200 || n12 == 201) {
                n11 = ByteArray.read32bit(byArray, n5 + 1);
                n11 = CodeIterator.newOffset(n5, n11, n2, n3, bl2);
                byArray2[n6++] = byArray[n5];
                ByteArray.write32bit(n11, byArray2, n6);
                n6 += 4;
            } else if (n12 == 170) {
                if (n5 != n6 && (n3 & 3) != 0) {
                    throw new CodeIterator$AlignmentException();
                }
                n11 = (n5 & 0xFFFFFFFC) + 4;
                n6 = CodeIterator.copyGapBytes(byArray2, n6, byArray, n5, n11);
                n10 = CodeIterator.newOffset(n5, ByteArray.read32bit(byArray, n11), n2, n3, bl2);
                ByteArray.write32bit(n10, byArray2, n6);
                n9 = ByteArray.read32bit(byArray, n11 + 4);
                ByteArray.write32bit(n9, byArray2, n6 + 4);
                n8 = ByteArray.read32bit(byArray, n11 + 8);
                ByteArray.write32bit(n8, byArray2, n6 + 8);
                n6 += 12;
                n7 = n11 + 12;
                n11 = n7 + (n8 - n9 + 1) * 4;
                while (n7 < n11) {
                    int n14 = CodeIterator.newOffset(n5, ByteArray.read32bit(byArray, n7), n2, n3, bl2);
                    ByteArray.write32bit(n14, byArray2, n6);
                    n6 += 4;
                    n7 += 4;
                }
            } else if (n12 == 171) {
                if (n5 != n6 && (n3 & 3) != 0) {
                    throw new CodeIterator$AlignmentException();
                }
                n11 = (n5 & 0xFFFFFFFC) + 4;
                n6 = CodeIterator.copyGapBytes(byArray2, n6, byArray, n5, n11);
                n10 = CodeIterator.newOffset(n5, ByteArray.read32bit(byArray, n11), n2, n3, bl2);
                ByteArray.write32bit(n10, byArray2, n6);
                n9 = ByteArray.read32bit(byArray, n11 + 4);
                ByteArray.write32bit(n9, byArray2, n6 + 4);
                n6 += 8;
                n8 = n11 + 8;
                n11 = n8 + n9 * 8;
                while (n8 < n11) {
                    ByteArray.copy32bit(byArray, n8, byArray2, n6);
                    n7 = CodeIterator.newOffset(n5, ByteArray.read32bit(byArray, n8 + 4), n2, n3, bl2);
                    ByteArray.write32bit(n7, byArray2, n6 + 4);
                    n6 += 8;
                    n8 += 8;
                }
            } else {
                while (n5 < n13) {
                    byArray2[n6++] = byArray[n5++];
                }
            }
            n5 = n13;
        }
    }

    private static int copyGapBytes(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        switch (n4 - n3) {
            case 4: {
                byArray[n2++] = byArray2[n3++];
            }
            case 3: {
                byArray[n2++] = byArray2[n3++];
            }
            case 2: {
                byArray[n2++] = byArray2[n3++];
            }
            case 1: {
                byArray[n2++] = byArray2[n3++];
            }
        }
        return n2;
    }

    private static int newOffset(int n2, int n3, int n4, int n5, boolean bl2) {
        int n6 = n2 + n3;
        if (n2 < n4) {
            if (n4 < n6 || bl2 && n4 == n6) {
                n3 += n5;
            }
        } else if (n2 == n4) {
            if (n6 < n4) {
                n3 -= n5;
            }
        } else if (n6 < n4 || !bl2 && n4 == n6) {
            n3 -= n5;
        }
        return n3;
    }

    static byte[] changeLdcToLdcW(byte[] byArray, ExceptionTable exceptionTable, CodeAttribute codeAttribute, CodeAttribute$LdcEntry codeAttribute$LdcEntry) throws BadBytecode {
        CodeIterator$Pointers codeIterator$Pointers = new CodeIterator$Pointers(0, 0, 0, exceptionTable, codeAttribute);
        ArrayList arrayList = CodeIterator.makeJumpList(byArray, byArray.length, codeIterator$Pointers);
        while (codeAttribute$LdcEntry != null) {
            CodeIterator.addLdcW(codeAttribute$LdcEntry, arrayList);
            codeAttribute$LdcEntry = codeAttribute$LdcEntry.next;
        }
        byte[] byArray2 = CodeIterator.insertGap2w(byArray, 0, 0, false, arrayList, codeIterator$Pointers);
        return byArray2;
    }

    private static void addLdcW(CodeAttribute$LdcEntry codeAttribute$LdcEntry, ArrayList arrayList) {
        int n2 = codeAttribute$LdcEntry.where;
        CodeIterator$LdcW codeIterator$LdcW = new CodeIterator$LdcW(n2, codeAttribute$LdcEntry.index);
        int n3 = arrayList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 >= ((CodeIterator$Branch)arrayList.get((int)i2)).orgPos) continue;
            arrayList.add(i2, codeIterator$LdcW);
            return;
        }
        arrayList.add(codeIterator$LdcW);
    }

    private byte[] insertGapCore0w(byte[] byArray, int n2, int n3, boolean bl2, ExceptionTable exceptionTable, CodeAttribute codeAttribute, CodeIterator$Gap codeIterator$Gap) throws BadBytecode {
        if (n3 <= 0) {
            return byArray;
        }
        CodeIterator$Pointers codeIterator$Pointers = new CodeIterator$Pointers(this.currentPos, this.mark, n2, exceptionTable, codeAttribute);
        ArrayList arrayList = CodeIterator.makeJumpList(byArray, byArray.length, codeIterator$Pointers);
        byte[] byArray2 = CodeIterator.insertGap2w(byArray, n2, n3, bl2, arrayList, codeIterator$Pointers);
        this.currentPos = codeIterator$Pointers.cursor;
        this.mark = codeIterator$Pointers.mark;
        int n4 = codeIterator$Pointers.mark0;
        if (n4 == this.currentPos && !bl2) {
            this.currentPos += n3;
        }
        if (bl2) {
            n4 -= n3;
        }
        codeIterator$Gap.position = n4;
        codeIterator$Gap.length = n3;
        return byArray2;
    }

    private static byte[] insertGap2w(byte[] byArray, int n2, int n3, boolean bl2, ArrayList arrayList, CodeIterator$Pointers codeIterator$Pointers) throws BadBytecode {
        int n4;
        int n5 = arrayList.size();
        if (n3 > 0) {
            codeIterator$Pointers.shiftPc(n2, n3, bl2);
            for (n4 = 0; n4 < n5; ++n4) {
                ((CodeIterator$Branch)arrayList.get(n4)).shift(n2, n3, bl2);
            }
        }
        n4 = 1;
        block1: while (true) {
            int n6;
            int n7;
            int n8;
            CodeIterator$Branch codeIterator$Branch;
            int n9;
            if (n4 != 0) {
                n4 = 0;
                n9 = 0;
                while (true) {
                    if (n9 >= n5) continue block1;
                    codeIterator$Branch = (CodeIterator$Branch)arrayList.get(n9);
                    if (codeIterator$Branch.expanded()) {
                        n4 = 1;
                        n8 = codeIterator$Branch.pos;
                        n7 = codeIterator$Branch.deltaSize();
                        codeIterator$Pointers.shiftPc(n8, n7, false);
                        for (n6 = 0; n6 < n5; ++n6) {
                            ((CodeIterator$Branch)arrayList.get(n6)).shift(n8, n7, false);
                        }
                    }
                    ++n9;
                }
            }
            for (n9 = 0; n9 < n5; ++n9) {
                codeIterator$Branch = (CodeIterator$Branch)arrayList.get(n9);
                n8 = codeIterator$Branch.gapChanged();
                if (n8 <= 0) continue;
                n4 = 1;
                n7 = codeIterator$Branch.pos;
                codeIterator$Pointers.shiftPc(n7, n8, false);
                for (n6 = 0; n6 < n5; ++n6) {
                    ((CodeIterator$Branch)arrayList.get(n6)).shift(n7, n8, false);
                }
            }
            if (n4 == 0) break;
        }
        return CodeIterator.makeExapndedCode(byArray, arrayList, n2, n3);
    }

    private static ArrayList makeJumpList(byte[] byArray, int n2, CodeIterator$Pointers codeIterator$Pointers) throws BadBytecode {
        ArrayList<CodeIterator$Branch> arrayList = new ArrayList<CodeIterator$Branch>();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5;
            int n6;
            int n7 = CodeIterator.nextOpcode(byArray, n3);
            int n8 = byArray[n3] & 0xFF;
            if (153 <= n8 && n8 <= 168 || n8 == 198 || n8 == 199) {
                n6 = byArray[n3 + 1] << 8 | byArray[n3 + 2] & 0xFF;
                CodeIterator$Branch16 codeIterator$Branch16 = n8 == 167 || n8 == 168 ? new CodeIterator$Jump16(n3, n6) : new CodeIterator$If16(n3, n6);
                arrayList.add(codeIterator$Branch16);
            } else if (n8 == 200 || n8 == 201) {
                n6 = ByteArray.read32bit(byArray, n3 + 1);
                arrayList.add(new CodeIterator$Jump32(n3, n6));
            } else if (n8 == 170) {
                n6 = (n3 & 0xFFFFFFFC) + 4;
                int n9 = ByteArray.read32bit(byArray, n6);
                n5 = ByteArray.read32bit(byArray, n6 + 4);
                n4 = ByteArray.read32bit(byArray, n6 + 8);
                int n10 = n6 + 12;
                int n11 = n4 - n5 + 1;
                int[] nArray = new int[n11];
                for (int i2 = 0; i2 < n11; ++i2) {
                    nArray[i2] = ByteArray.read32bit(byArray, n10);
                    n10 += 4;
                }
                arrayList.add(new CodeIterator$Table(n3, n9, n5, n4, nArray, codeIterator$Pointers));
            } else if (n8 == 171) {
                n6 = (n3 & 0xFFFFFFFC) + 4;
                int n12 = ByteArray.read32bit(byArray, n6);
                n5 = ByteArray.read32bit(byArray, n6 + 4);
                n4 = n6 + 8;
                int[] nArray = new int[n5];
                int[] nArray2 = new int[n5];
                for (int i3 = 0; i3 < n5; ++i3) {
                    nArray[i3] = ByteArray.read32bit(byArray, n4);
                    nArray2[i3] = ByteArray.read32bit(byArray, n4 + 4);
                    n4 += 8;
                }
                arrayList.add(new CodeIterator$Lookup(n3, n12, nArray, nArray2, codeIterator$Pointers));
            }
            n3 = n7;
        }
        return arrayList;
    }

    private static byte[] makeExapndedCode(byte[] byArray, ArrayList arrayList, int n2, int n3) throws BadBytecode {
        int n4;
        CodeIterator$Branch codeIterator$Branch;
        int n5 = arrayList.size();
        int n6 = byArray.length + n3;
        for (int i2 = 0; i2 < n5; ++i2) {
            CodeIterator$Branch codeIterator$Branch2 = (CodeIterator$Branch)arrayList.get(i2);
            n6 += codeIterator$Branch2.deltaSize();
        }
        byte[] byArray2 = new byte[n6];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = byArray.length;
        if (0 < n5) {
            codeIterator$Branch = (CodeIterator$Branch)arrayList.get(0);
            n4 = codeIterator$Branch.orgPos;
        } else {
            codeIterator$Branch = null;
            n4 = n10;
        }
        while (n7 < n10) {
            int n11;
            if (n7 == n2) {
                n11 = n8 + n3;
                while (n8 < n11) {
                    byArray2[n8++] = 0;
                }
            }
            if (n7 != n4) {
                byArray2[n8++] = byArray[n7++];
                continue;
            }
            n11 = codeIterator$Branch.write(n7, byArray, n8, byArray2);
            n7 += n11;
            n8 += n11 + codeIterator$Branch.deltaSize();
            if (++n9 < n5) {
                codeIterator$Branch = (CodeIterator$Branch)arrayList.get(n9);
                n4 = codeIterator$Branch.orgPos;
                continue;
            }
            codeIterator$Branch = null;
            n4 = n10;
        }
        return byArray2;
    }
}

