/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.Annotation$Pair;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationImpl;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationMemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationsWriter;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.ArrayMemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.BooleanMemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.ByteMemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.CharMemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.ClassMemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.DoubleMemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.EnumMemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.FloatMemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.IntegerMemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.LongMemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.NoSuchClassError;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.ShortMemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.StringMemberValue;

public class Annotation {
    ConstPool pool;
    int typeIndex;
    LinkedHashMap members;

    public Annotation(int n2, ConstPool constPool) {
        this.pool = constPool;
        this.typeIndex = n2;
        this.members = null;
    }

    public Annotation(String string, ConstPool constPool) {
        this(constPool.addUtf8Info(Descriptor.of(string)), constPool);
    }

    public Annotation(ConstPool constPool, CtClass ctClass) throws NotFoundException {
        this(constPool.addUtf8Info(Descriptor.of(ctClass.getName())), constPool);
        if (!ctClass.isInterface()) {
            throw new RuntimeException("Only interfaces are allowed for Annotation creation.");
        }
        CtMethod[] ctMethodArray = ctClass.getDeclaredMethods();
        if (ctMethodArray.length > 0) {
            this.members = new LinkedHashMap();
        }
        for (int i2 = 0; i2 < ctMethodArray.length; ++i2) {
            CtClass ctClass2 = ctMethodArray[i2].getReturnType();
            this.addMemberValue(ctMethodArray[i2].getName(), Annotation.createMemberValue(constPool, ctClass2));
        }
    }

    public static MemberValue createMemberValue(ConstPool constPool, CtClass ctClass) throws NotFoundException {
        if (ctClass == CtClass.booleanType) {
            return new BooleanMemberValue(constPool);
        }
        if (ctClass == CtClass.byteType) {
            return new ByteMemberValue(constPool);
        }
        if (ctClass == CtClass.charType) {
            return new CharMemberValue(constPool);
        }
        if (ctClass == CtClass.shortType) {
            return new ShortMemberValue(constPool);
        }
        if (ctClass == CtClass.intType) {
            return new IntegerMemberValue(constPool);
        }
        if (ctClass == CtClass.longType) {
            return new LongMemberValue(constPool);
        }
        if (ctClass == CtClass.floatType) {
            return new FloatMemberValue(constPool);
        }
        if (ctClass == CtClass.doubleType) {
            return new DoubleMemberValue(constPool);
        }
        if (ctClass.getName().equals("java.lang.Class")) {
            return new ClassMemberValue(constPool);
        }
        if (ctClass.getName().equals("java.lang.String")) {
            return new StringMemberValue(constPool);
        }
        if (ctClass.isArray()) {
            CtClass ctClass2 = ctClass.getComponentType();
            MemberValue memberValue = Annotation.createMemberValue(constPool, ctClass2);
            return new ArrayMemberValue(memberValue, constPool);
        }
        if (ctClass.isInterface()) {
            Annotation annotation = new Annotation(constPool, ctClass);
            return new AnnotationMemberValue(annotation, constPool);
        }
        EnumMemberValue enumMemberValue = new EnumMemberValue(constPool);
        enumMemberValue.setType(ctClass.getName());
        return enumMemberValue;
    }

    public void addMemberValue(int n2, MemberValue memberValue) {
        Annotation$Pair annotation$Pair = new Annotation$Pair();
        annotation$Pair.name = n2;
        annotation$Pair.value = memberValue;
        this.addMemberValue(annotation$Pair);
    }

    public void addMemberValue(String string, MemberValue memberValue) {
        Annotation$Pair annotation$Pair = new Annotation$Pair();
        annotation$Pair.name = this.pool.addUtf8Info(string);
        annotation$Pair.value = memberValue;
        if (this.members == null) {
            this.members = new LinkedHashMap();
        }
        this.members.put(string, annotation$Pair);
    }

    private void addMemberValue(Annotation$Pair annotation$Pair) {
        String string = this.pool.getUtf8Info(annotation$Pair.name);
        if (this.members == null) {
            this.members = new LinkedHashMap();
        }
        this.members.put(string, annotation$Pair);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("@");
        stringBuffer.append(this.getTypeName());
        if (this.members != null) {
            stringBuffer.append("(");
            Iterator iterator = this.members.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string).append("=").append(this.getMemberValue(string));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String getTypeName() {
        return Descriptor.toClassName(this.pool.getUtf8Info(this.typeIndex));
    }

    public Set getMemberNames() {
        if (this.members == null) {
            return null;
        }
        return this.members.keySet();
    }

    public MemberValue getMemberValue(String string) {
        if (this.members == null) {
            return null;
        }
        Annotation$Pair annotation$Pair = (Annotation$Pair)this.members.get(string);
        if (annotation$Pair == null) {
            return null;
        }
        return annotation$Pair.value;
    }

    public Object toAnnotationType(ClassLoader classLoader, ClassPool classPool) throws ClassNotFoundException, NoSuchClassError {
        return AnnotationImpl.make(classLoader, MemberValue.loadClass(classLoader, this.getTypeName()), classPool, this);
    }

    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        String string = this.pool.getUtf8Info(this.typeIndex);
        if (this.members == null) {
            annotationsWriter.annotation(string, 0);
            return;
        }
        annotationsWriter.annotation(string, this.members.size());
        Iterator iterator = this.members.values().iterator();
        while (iterator.hasNext()) {
            Annotation$Pair annotation$Pair = (Annotation$Pair)iterator.next();
            annotationsWriter.memberValuePair(annotation$Pair.name);
            annotation$Pair.value.write(annotationsWriter);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Annotation)) {
            return false;
        }
        Annotation annotation = (Annotation)object;
        if (!this.getTypeName().equals(annotation.getTypeName())) {
            return false;
        }
        LinkedHashMap linkedHashMap = annotation.members;
        if (this.members == linkedHashMap) {
            return true;
        }
        if (this.members == null) {
            return linkedHashMap == null;
        }
        if (linkedHashMap == null) {
            return false;
        }
        return this.members.equals(linkedHashMap);
    }
}

