/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.io.OutputStream;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;

public class AnnotationsWriter {
    private OutputStream output;
    private ConstPool pool;

    public AnnotationsWriter(OutputStream outputStream, ConstPool constPool) {
        this.output = outputStream;
        this.pool = constPool;
    }

    public ConstPool getConstPool() {
        return this.pool;
    }

    public void close() throws IOException {
        this.output.close();
    }

    public void numParameters(int n2) throws IOException {
        this.output.write(n2);
    }

    public void numAnnotations(int n2) throws IOException {
        this.write16bit(n2);
    }

    public void annotation(String string, int n2) throws IOException {
        this.annotation(this.pool.addUtf8Info(string), n2);
    }

    public void annotation(int n2, int n3) throws IOException {
        this.write16bit(n2);
        this.write16bit(n3);
    }

    public void memberValuePair(String string) throws IOException {
        this.memberValuePair(this.pool.addUtf8Info(string));
    }

    public void memberValuePair(int n2) throws IOException {
        this.write16bit(n2);
    }

    public void constValueIndex(boolean bl2) throws IOException {
        this.constValueIndex(90, this.pool.addIntegerInfo(bl2 ? 1 : 0));
    }

    public void constValueIndex(byte by2) throws IOException {
        this.constValueIndex(66, this.pool.addIntegerInfo(by2));
    }

    public void constValueIndex(char c2) throws IOException {
        this.constValueIndex(67, this.pool.addIntegerInfo(c2));
    }

    public void constValueIndex(short s2) throws IOException {
        this.constValueIndex(83, this.pool.addIntegerInfo(s2));
    }

    public void constValueIndex(int n2) throws IOException {
        this.constValueIndex(73, this.pool.addIntegerInfo(n2));
    }

    public void constValueIndex(long l2) throws IOException {
        this.constValueIndex(74, this.pool.addLongInfo(l2));
    }

    public void constValueIndex(float f2) throws IOException {
        this.constValueIndex(70, this.pool.addFloatInfo(f2));
    }

    public void constValueIndex(double d2) throws IOException {
        this.constValueIndex(68, this.pool.addDoubleInfo(d2));
    }

    public void constValueIndex(String string) throws IOException {
        this.constValueIndex(115, this.pool.addUtf8Info(string));
    }

    public void constValueIndex(int n2, int n3) throws IOException {
        this.output.write(n2);
        this.write16bit(n3);
    }

    public void enumConstValue(String string, String string2) throws IOException {
        this.enumConstValue(this.pool.addUtf8Info(string), this.pool.addUtf8Info(string2));
    }

    public void enumConstValue(int n2, int n3) throws IOException {
        this.output.write(101);
        this.write16bit(n2);
        this.write16bit(n3);
    }

    public void classInfoIndex(String string) throws IOException {
        this.classInfoIndex(this.pool.addUtf8Info(string));
    }

    public void classInfoIndex(int n2) throws IOException {
        this.output.write(99);
        this.write16bit(n2);
    }

    public void annotationValue() throws IOException {
        this.output.write(64);
    }

    public void arrayValue(int n2) throws IOException {
        this.output.write(91);
        this.write16bit(n2);
    }

    private void write16bit(int n2) throws IOException {
        byte[] byArray = new byte[2];
        ByteArray.write16bit(n2, byArray, 0);
        this.output.write(byArray);
    }
}

