/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.AnnotationsWriter;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValue;
import org.zeroturnaround.bundled.javassist.bytecode.annotation.MemberValueVisitor;

public class FloatMemberValue
extends MemberValue {
    int valueIndex;

    public FloatMemberValue(int n2, ConstPool constPool) {
        super('F', constPool);
        this.valueIndex = n2;
    }

    public FloatMemberValue(float f2, ConstPool constPool) {
        super('F', constPool);
        this.setValue(f2);
    }

    public FloatMemberValue(ConstPool constPool) {
        super('F', constPool);
        this.setValue(0.0f);
    }

    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Float(this.getValue());
    }

    Class getType(ClassLoader classLoader) {
        return Float.TYPE;
    }

    public float getValue() {
        return this.cp.getFloatInfo(this.valueIndex);
    }

    public void setValue(float f2) {
        this.valueIndex = this.cp.addFloatInfo(f2);
    }

    public String toString() {
        return Float.toString(this.getValue());
    }

    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitFloatMemberValue(this);
    }
}

